/*
 * Decompiled with CFR 0.152.
 */
package com.vartan.abc.model;

import com.google.common.collect.ImmutableMap;
import com.vartan.abc.model.AmountDiffer;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.StatChanged;

public class XpTracker {
    private final ImmutableMap<Skill, AmountDiffer> xpDiffs;

    public XpTracker(List<Skill> skills) {
        ImmutableMap.Builder xpDiffsBuilder = ImmutableMap.builder();
        for (Skill skill : skills) {
            xpDiffsBuilder.put((Object)skill, (Object)new AmountDiffer());
        }
        this.xpDiffs = xpDiffsBuilder.build();
    }

    public void update(Client client) {
        for (Skill skill : this.xpDiffs.keySet()) {
            AmountDiffer xpDiff = (AmountDiffer)this.xpDiffs.get((Object)skill);
            xpDiff.put(client.getSkillExperience(skill));
        }
    }

    public int onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        if (!this.xpDiffs.containsKey((Object)skill)) {
            return -1;
        }
        int currentXp = statChanged.getXp();
        int xpDiff = ((AmountDiffer)this.xpDiffs.get((Object)skill)).put(currentXp).getDiff();
        return xpDiff;
    }
}

