/*
 * Decompiled with CFR 0.152.
 */
package com.vartan.abc.model;

import java.time.Duration;
import java.time.Instant;

public class TickCounter {
    private static final int GAME_TICK_DURATION_MS = 600;
    private int ticks = 0;
    private int fullValue = 0;
    private Instant lastTick = Instant.now();

    public TickCounter() {
    }

    public TickCounter(int ticks) {
        this.set(ticks);
    }

    public boolean isRunning() {
        return this.ticks > 0;
    }

    public int getTicksRemaining() {
        return Math.max(this.ticks, 0);
    }

    public int getTicksElapsed() {
        return this.fullValue - this.getTicksRemaining();
    }

    public boolean justElapsed() {
        return this.ticks == 0;
    }

    public void reset() {
        this.ticks = this.fullValue;
    }

    public void set(int value) {
        this.fullValue = value;
        this.ticks = value;
    }

    public void tick() {
        this.lastTick = Instant.now();
        if (this.ticks >= 0) {
            --this.ticks;
        }
    }

    public double getPercentDone() {
        int wholeTicksRemaining = this.getTicksRemaining();
        if (wholeTicksRemaining <= 0) {
            return 1.0;
        }
        double msSinceLastTick = Duration.between(this.lastTick, Instant.now()).toMillis();
        double fractionalTickPercent = Math.min(msSinceLastTick / 600.0, wholeTicksRemaining == 1 ? 0.75 : 1.0);
        double ticksRemaining = (double)wholeTicksRemaining - fractionalTickPercent;
        double ticksPercent = 1.0 - ticksRemaining / (double)this.fullValue;
        return ticksPercent;
    }

    public int getFullValue() {
        return this.fullValue;
    }
}

