/*
 * Decompiled with CFR 0.152.
 */
package com.vartan.abc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.inject.Provides;
import com.vartan.abc.AbcAlchConfig;
import com.vartan.abc.AbcAlchOverlay;
import com.vartan.abc.AbcAlchPanel;
import com.vartan.abc.model.AlchItem;
import com.vartan.abc.model.Spell;
import com.vartan.abc.model.TickCounter;
import com.vartan.abc.model.XpTracker;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.item.ItemPrice;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ABC Alchemy")
public class AbcAlchPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AbcAlchPlugin.class);
    private static final int TICKS_PER_MINUTE = 100;
    public final TickCounter magicTicker = new TickCounter();
    public final TickCounter alchOverlayTimer = new TickCounter();
    public final TickCounter hideSpellbookHintTimer = new TickCounter();
    public boolean readyForPriceUpdate = true;
    public boolean useWikiPrices = true;
    @Inject
    private Client client;
    @Inject
    private AbcAlchConfig config;
    @Inject
    private AbcAlchOverlay abcAlchOverlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientToolbar clientToolbar;
    private List<AlchItem> alchItems;
    private final ArrayList<TickCounter> tickCounters = new ArrayList();
    private NavigationButton navButton;
    private AbcAlchPanel panel;
    private final XpTracker xpTracker = new XpTracker((List<Skill>)ImmutableList.of((Object)Skill.MAGIC));

    protected void startUp() throws Exception {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.onLoginOrActivated();
        }
        this.panel = new AbcAlchPanel(this, this.client, this.itemManager);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        this.navButton = NavigationButton.builder().tooltip("ABC Alchemy").icon(icon).priority(2).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.tickCounters.add(this.magicTicker);
        this.tickCounters.add(this.alchOverlayTimer);
        this.tickCounters.add(this.hideSpellbookHintTimer);
        this.overlayManager.add((Overlay)this.abcAlchOverlay);
    }

    public void updatePriceList() {
        List itemPrices = this.itemManager.search("");
        int natureRunePrice = this.itemManager.getItemPrice(561);
        ArrayList<AlchItem> tempAlchItems = new ArrayList<AlchItem>();
        for (ItemPrice price : itemPrices) {
            int itemId = price.getId();
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            ItemStats itemStats = this.itemManager.getItemStats(itemId, false);
            String name = price.getName();
            if (itemStats == null || itemComposition == null || name.length() == 0) continue;
            int gePrice = this.useWikiPrices ? this.itemManager.getWikiPrice(price) : price.getPrice();
            int highAlchPrice = itemComposition.getHaPrice();
            int highAlchProfit = highAlchPrice - gePrice - natureRunePrice;
            int geLimit = itemStats.getGeLimit();
            if (highAlchProfit < 0) continue;
            AsyncBufferedImage image = this.itemManager.getImage(itemId, geLimit, false);
            tempAlchItems.add(new AlchItem(name, gePrice, highAlchPrice, highAlchProfit, geLimit, (BufferedImage)image));
        }
        this.alchItems = Ordering.from(Comparator.comparing(AlchItem::getHighAlchProfit)).reverse().immutableSortedCopy(tempAlchItems);
        SwingUtilities.invokeLater(() -> this.panel.updateItemList());
        this.readyForPriceUpdate = false;
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.overlayManager.remove((Overlay)this.abcAlchOverlay);
        for (TickCounter counter : this.tickCounters) {
            this.tickCounters.remove(counter);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.onLoginOrActivated();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        boolean wasAlch;
        boolean bl = wasAlch = menuOptionClicked.getMenuAction() == MenuAction.WIDGET_TARGET_ON_WIDGET && menuOptionClicked.getMenuTarget().contains("High Level Alchemy");
        if (wasAlch) {
            this.hideSpellbookHintTimer.set(Spell.HIGH_LEVEL_ALCHEMY.cooldown + 1);
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Actor actor = event.getActor();
        String actorName = actor.getName();
        if (actor != this.client.getLocalPlayer()) {
            // empty if block
        }
    }

    @Provides
    AbcAlchConfig provideConfig(ConfigManager configManager) {
        return (AbcAlchConfig)configManager.getConfig(AbcAlchConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.tickCounters.forEach(TickCounter::tick);
        if (this.magicTicker.justElapsed()) {
            this.maybePlayAudioHint();
        }
        if (this.readyForPriceUpdate && this.client.getGameState() == GameState.LOGGED_IN) {
            this.updatePriceList();
        }
        if (this.menuIsCast()) {
            this.alchOverlayTimer.set(100);
        }
    }

    private void maybePlayAudioHint() {
        int volume = this.config.audioHintVolume();
        if (volume != 0) {
            this.client.playSoundEffect(this.config.audioHintSoundEffect().id, volume);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int xpDiff = this.xpTracker.onStatChanged(statChanged);
        if (xpDiff < 0) {
            return;
        }
        if (Objects.requireNonNull(skill) == Skill.MAGIC) {
            for (Spell spell : Spell.values()) {
                if (xpDiff != spell.xpGained) continue;
                this.onMagicXpGained(spell);
                break;
            }
        }
    }

    private void onMagicXpGained(Spell spell) {
        this.magicTicker.set(spell.cooldown);
    }

    public List<AlchItem> getAlchItems() {
        return this.alchItems;
    }

    public boolean menuIsCast() {
        Widget selectedWidget = this.client.getSelectedWidget();
        Widget alchWidget = this.client.getWidget(218, Spell.HIGH_LEVEL_ALCHEMY.widgetChildId);
        return selectedWidget != null && selectedWidget == alchWidget;
    }

    private void onLoginOrActivated() {
        this.readyForPriceUpdate = true;
        this.xpTracker.update(this.client);
    }
}

