/*
 * Decompiled with CFR 0.152.
 */
package com.vartan.abc;

import com.vartan.abc.AbcAlchPlugin;
import com.vartan.abc.model.AlchItem;
import com.vartan.abc.util.IntegerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbcAlchPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(AbcAlchPanel.class);
    private static final String[] PRICE_SOURCE_OPTIONS = new String[]{"Wiki Prices", "Standard Prices"};
    private static final int WIKI_PRICES_INDEX = 0;
    private final Client client;
    private final ItemManager itemManager;
    JTextField minimumTradeLimitField;
    JTextField maxPriceField;
    JComboBox priceSourceBox;
    AbcAlchPlugin plugin;
    JPanel alchList;

    public AbcAlchPanel(final AbcAlchPlugin plugin, Client client, ItemManager itemManager) {
        this.plugin = plugin;
        this.client = client;
        this.itemManager = itemManager;
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel layoutPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(layoutPanel, 1);
        layoutPanel.setLayout(boxLayout);
        this.add(layoutPanel, "North");
        this.maxPriceField = new JTextField();
        JPanel maxPriceRow = AbcAlchPanel.createLabeledRow("Max Price:", this.maxPriceField);
        maxPriceRow.setToolTipText("Filters out items with a GE price more than the given value. 0 to disable.");
        layoutPanel.add(maxPriceRow);
        this.minimumTradeLimitField = new JTextField();
        JPanel minimumTradeLimitRow = AbcAlchPanel.createLabeledRow("Min Trade Limit:", this.minimumTradeLimitField);
        minimumTradeLimitRow.setToolTipText("Filters out items with a trade limit less than the given value. 0 to disable.");
        layoutPanel.add(minimumTradeLimitRow);
        this.priceSourceBox = new JComboBox<String>(PRICE_SOURCE_OPTIONS);
        this.priceSourceBox.setSelectedIndex(0);
        this.priceSourceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.useWikiPrices = AbcAlchPanel.this.priceSourceBox.getSelectedIndex() == 0;
                plugin.readyForPriceUpdate = true;
            }
        });
        layoutPanel.add(AbcAlchPanel.createLabeledRow("Price Source:", this.priceSourceBox));
        JButton searchButton = new JButton("Search");
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.readyForPriceUpdate = true;
            }
        });
        layoutPanel.add(searchButton);
        this.alchList = new JPanel();
        layoutPanel.add(this.alchList);
        BoxLayout alchListBoxLayout = new BoxLayout(this.alchList, 1);
        this.alchList.setLayout(alchListBoxLayout);
        this.alchList.add(new JLabel("Prices will appear once an account is logged in."));
        this.updateItemList();
        this.add(this.alchList);
    }

    private static int readNumericTextField(JTextField field) {
        try {
            return Integer.parseInt(field.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static JPanel createLabeledRow(String label, Component item) {
        JPanel rowPanel = new JPanel();
        rowPanel.setLayout(new GridLayout(1, 2));
        rowPanel.add(new JLabel(label));
        rowPanel.add(item);
        return rowPanel;
    }

    public void updateItemList() {
        if (this.plugin.getAlchItems() == null) {
            return;
        }
        this.alchList.removeAll();
        for (AlchItem item : this.plugin.getAlchItems()) {
            boolean filterPrice;
            int geLimit = item.getGeLimit();
            int minimumTradeLimit = AbcAlchPanel.readNumericTextField(this.minimumTradeLimitField);
            int maxPrice = AbcAlchPanel.readNumericTextField(this.maxPriceField);
            boolean filterGeLimit = geLimit != 0 && minimumTradeLimit != 0 && geLimit < minimumTradeLimit;
            boolean bl = filterPrice = maxPrice != 0 && item.getGePrice() >= maxPrice;
            if (filterGeLimit || filterPrice) continue;
            if (item.getHighAlchProfit() <= 0) break;
            JPanel alchItemContainer = this.generateItemContainer(item);
            this.alchList.add(alchItemContainer);
        }
        this.alchList.revalidate();
    }

    private JPanel generateItemContainer(AlchItem item) {
        JPanel alchItemContainer = new JPanel();
        alchItemContainer.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        alchItemContainer.setLayout(new BoxLayout(alchItemContainer, 0));
        this.alchList.add(alchItemContainer);
        BufferedImage itemImage = item.getImage();
        JLabel iconLabel = new JLabel(new ImageIcon(itemImage));
        iconLabel.setToolTipText(item.getName() + " has a Grand Exchange buy limit of " + item.getGeLimit() + " every 4 hours");
        alchItemContainer.add(iconLabel);
        JPanel alchItemContent = new JPanel();
        alchItemContent.setLayout(new BoxLayout(alchItemContent, 1));
        alchItemContainer.add(alchItemContent);
        JLabel itemNameLabel = new JLabel(item.getName(), 2);
        itemNameLabel.setForeground(Color.WHITE);
        alchItemContent.setAlignmentX(0.0f);
        alchItemContent.add(itemNameLabel);
        JPanel subtextContainer = this.createSubtextContainer(item);
        alchItemContent.add(subtextContainer);
        return alchItemContainer;
    }

    private JPanel createSubtextContainer(AlchItem item) {
        JPanel subtextContainer = new JPanel();
        subtextContainer.setLayout(new GridLayout(2, 2));
        Font smallFont = FontManager.getRunescapeSmallFont();
        JLabel alchPriceLabel = new JLabel("Alch: " + IntegerUtil.toShorthand(item.getHighAlchPrice()));
        alchPriceLabel.setToolTipText("High Alch Price: " + item.getHighAlchPrice());
        alchPriceLabel.setForeground(Color.YELLOW);
        alchPriceLabel.setFont(smallFont);
        subtextContainer.setAlignmentX(0.0f);
        subtextContainer.add(alchPriceLabel);
        JLabel alchProfitLabel = new JLabel("Profit: " + IntegerUtil.toShorthand(item.getHighAlchProfit()));
        alchProfitLabel.setToolTipText("High Alch Profit: " + item.getHighAlchProfit());
        alchProfitLabel.setForeground(Color.GREEN);
        alchProfitLabel.setFont(smallFont);
        subtextContainer.setAlignmentX(0.0f);
        subtextContainer.add(alchProfitLabel);
        JLabel gePriceLabel = new JLabel("GE: " + IntegerUtil.toShorthand(item.getGePrice()));
        gePriceLabel.setToolTipText("Grand Exchange Price: " + item.getGePrice());
        gePriceLabel.setForeground(Color.ORANGE);
        gePriceLabel.setFont(smallFont);
        subtextContainer.setAlignmentX(0.0f);
        subtextContainer.add(gePriceLabel);
        return subtextContainer;
    }
}

