/*
 * Decompiled with CFR 0.152.
 */
package com.vartan.abc;

import com.vartan.abc.AbcAlchConfig;
import com.vartan.abc.AbcAlchPlugin;
import com.vartan.abc.model.Spell;
import com.vartan.abc.util.PointUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class AbcAlchOverlay
extends Overlay {
    private static WidgetInfo[] SPELLBOOK_ICON_IDS = new WidgetInfo[]{WidgetInfo.RESIZABLE_VIEWPORT_MAGIC_ICON, WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_MAGIC_ICON, WidgetInfo.FIXED_VIEWPORT_MAGIC_ICON};
    private final Client client;
    private final AbcAlchConfig config;
    private final AbcAlchPlugin plugin;
    private Rectangle alchBounds = null;
    private Rectangle optimalItemBounds = null;
    private Rectangle alchIntersection = null;

    @Inject
    private AbcAlchOverlay(Client client, AbcAlchPlugin plugin, AbcAlchConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        Rectangle maybeBounds;
        Widget magicWidget = this.client.getWidget(218, Spell.HIGH_LEVEL_ALCHEMY.widgetChildId);
        if (magicWidget != null && (maybeBounds = magicWidget.getBounds()) != null) {
            this.alchBounds = maybeBounds;
        }
        this.updateInventoryBounds(graphics);
        if (!this.plugin.alchOverlayTimer.isRunning()) {
            return null;
        }
        if (this.alchBounds != null && this.config.showAlchBounds()) {
            graphics.setColor(this.config.alchBoundsColor());
            graphics.draw(this.alchBounds);
        }
        if (this.optimalItemBounds != null && this.config.showItemBounds()) {
            graphics.setColor(this.config.itemBoundsColor());
            graphics.draw(this.optimalItemBounds);
        }
        this.renderAlchIntersection(graphics, magicWidget);
        this.renderSpellbookClickHint(graphics, magicWidget);
        return null;
    }

    private void renderAlchIntersection(Graphics2D graphics, Widget magicWidget) {
        if (this.alchIntersection == null || !this.config.showAlchIntersection()) {
            return;
        }
        double magicReadyPercent = this.plugin.magicTicker.getPercentDone();
        boolean isReady = magicReadyPercent == 1.0;
        boolean mouseIntersects = this.alchIntersectionContainsMouse();
        Rectangle fillRect = this.getAlchFillRect(magicReadyPercent);
        Color statusColor = isReady ? this.config.readyColor() : this.config.pendingColor();
        graphics.setColor(statusColor);
        graphics.draw(fillRect);
        graphics.setColor(this.getAlchIntersectionColor((float)magicReadyPercent));
        graphics.fill(fillRect);
        boolean menuIsCast = this.plugin.menuIsCast();
        if (magicWidget != null && !magicWidget.isHidden() || menuIsCast && mouseIntersects) {
            graphics.setColor(statusColor);
        } else {
            graphics.setColor(this.config.misclickColor());
        }
        graphics.draw(this.alchIntersection);
        graphics.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
    }

    private boolean alchIntersectionContainsMouse() {
        return this.alchIntersection.contains(PointUtil.toAwtPoint(this.client.getMouseCanvasPosition()));
    }

    public void renderSpellbookClickHint(Graphics2D graphics, Widget magicWidget) {
        if (!this.config.spellbookClickHint() || this.plugin.hideSpellbookHintTimer.isRunning() || magicWidget != null && !magicWidget.isHidden()) {
            return;
        }
        if (this.plugin.alchOverlayTimer.getTicksElapsed() == 0) {
            return;
        }
        if (this.plugin.magicTicker.isRunning() && this.plugin.alchOverlayTimer.getTicksElapsed() > this.plugin.magicTicker.getFullValue()) {
            return;
        }
        Widget spellbookTab = this.getVisibleSpellbookTabWidget();
        if (spellbookTab == null) {
            return;
        }
        boolean menuIsCast = this.plugin.menuIsCast();
        if (menuIsCast) {
            return;
        }
        graphics.setColor(this.config.spellbookClickHintColor());
        graphics.draw(spellbookTab.getBounds());
    }

    private Widget getVisibleSpellbookTabWidget() {
        Widget tabWidget = null;
        for (int i = 0; i < SPELLBOOK_ICON_IDS.length && tabWidget == null; ++i) {
            tabWidget = this.client.getWidget(SPELLBOOK_ICON_IDS[i]);
            if (tabWidget == null || !tabWidget.isHidden()) continue;
            tabWidget = null;
        }
        return tabWidget;
    }

    public Color getAlchIntersectionColor(float magicReadyPercent) {
        Color readyColor = this.config.readyColor();
        Color pendingColor = this.config.pendingColor();
        float magicRemainingPercent = 1.0f - magicReadyPercent;
        return new Color(Math.min(1.0f, (float)readyColor.getRed() / 255.0f * magicReadyPercent + (float)pendingColor.getRed() / 255.0f * magicRemainingPercent), Math.min(1.0f, (float)readyColor.getGreen() / 255.0f * magicReadyPercent + (float)pendingColor.getGreen() / 255.0f * magicRemainingPercent), Math.min(1.0f, (float)readyColor.getBlue() / 255.0f * magicReadyPercent + (float)pendingColor.getBlue() / 255.0f * magicRemainingPercent), (float)this.config.intersectionFillOpacity() * ((float)readyColor.getAlpha() / 255.0f * magicReadyPercent + (float)pendingColor.getAlpha() / 255.0f * magicRemainingPercent));
    }

    public void updateInventoryBounds(Graphics2D graphics) {
        Widget inventoryWidget = this.client.getWidget(WidgetInfo.INVENTORY);
        if (inventoryWidget == null || this.alchBounds == null || inventoryWidget.isHidden()) {
            return;
        }
        Widget[] dynamicChildren = inventoryWidget.getDynamicChildren();
        if (dynamicChildren.length == 0) {
            return;
        }
        double largestIntersectionArea = 1.0;
        Rectangle largestOverlapItemBounds = null;
        Rectangle largestOverlapIntersection = null;
        for (Widget item : dynamicChildren) {
            double intersectionArea;
            Rectangle intersection;
            Rectangle itemBounds;
            if (item == null || item.isHidden() || (itemBounds = item.getBounds()) == null || (intersection = this.alchBounds.intersection(itemBounds)).isEmpty() || !((intersectionArea = intersection.getWidth() * intersection.getHeight()) > largestIntersectionArea)) continue;
            largestIntersectionArea = intersectionArea;
            largestOverlapItemBounds = itemBounds;
            largestOverlapIntersection = intersection;
        }
        if (largestOverlapItemBounds != null) {
            this.optimalItemBounds = largestOverlapItemBounds;
            this.alchIntersection = largestOverlapIntersection;
        }
    }

    private Rectangle getAlchFillRect(double magicReadyPercent) {
        if (this.alchIntersection.getHeight() > this.alchIntersection.getWidth()) {
            int indicatorY = (int)Math.round(this.alchIntersection.getY() + this.alchIntersection.getHeight() * (1.0 - magicReadyPercent));
            int indicatorHeight = (int)Math.round(this.alchIntersection.getHeight() * magicReadyPercent);
            return new Rectangle((int)this.alchIntersection.getX(), indicatorY, (int)this.alchIntersection.getWidth(), indicatorHeight);
        }
        return new Rectangle((int)this.alchIntersection.getX(), (int)this.alchIntersection.getY(), (int)Math.round(this.alchIntersection.getWidth() * magicReadyPercent), (int)Math.round(this.alchIntersection.getHeight()));
    }
}

