/*
 * Decompiled with CFR 0.152.
 */
package com.AttackSoundNotifications.ui;

import com.AttackSoundNotifications.AttackSoundNotificationsPlugin;
import com.AttackSoundNotifications.ui.AttackSoundNotificationsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.runelite.api.GameState;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(EntryPanel.class);
    private final JPanel mainPanel;
    private Integer weaponId = -1;
    private ImageIcon weaponIcon;
    private final AttackSoundNotificationsPanel pluginPanel;
    private final AttackSoundNotificationsPlugin plugin;
    private final JPanel textEntry;
    private final JLabel weaponLabel;
    private final JLabel removeEntry;
    private final JLabel audible;
    private final JTextField customSoundTextField;
    private final JLabel selectFile;
    private final JComboBox<AttackSoundNotificationsPanel.Condition> replacing;
    private final JLabel playing;
    private final JLabel clearPlaying;
    private final FlatTextField nameInput = new FlatTextField();
    private final JLabel rename = new JLabel("Rename");
    private final JLabel save = new JLabel("Save");
    private final JLabel cancel = new JLabel("Cancel");
    private static final Border NAME_BOTTOM_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR));
    public static final ImageIcon WEAPON_BACKGROUND;
    public static final BufferedImage DEFAULT_WEAPON_ICON;
    public static final ImageIcon DEFAULT_WEAPON_HOVER_ICON;
    public static final ImageIcon AUDIBLE_ICON;
    public static final ImageIcon AUDIBLE_HOVER_ICON;
    public static final ImageIcon INAUDIBLE_ICON;
    public static final ImageIcon INAUDIBLE_HOVER_ICON;
    public static final ImageIcon REMOVE_ICON;
    public static final ImageIcon REMOVE_HOVER_ICON;
    public static final ImageIcon OPEN_ICON;
    public static final ImageIcon OPEN_HOVER_ICON;

    public EntryPanel(AttackSoundNotificationsPanel passedPanel, AttackSoundNotificationsPlugin passedPlugin) {
        this.pluginPanel = passedPanel;
        this.plugin = passedPlugin;
        this.setName("Custom Sound " + (this.pluginPanel.entryPanel.getComponentCount() + 1));
        this.weaponLabel = new JLabel();
        this.weaponLabel.setHorizontalAlignment(0);
        this.weaponLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setWeaponIcons(DEFAULT_WEAPON_ICON);
        this.customSoundTextField = new JTextField();
        this.customSoundTextField.setFocusable(true);
        this.replacing = new JComboBox<AttackSoundNotificationsPanel.Condition>(new DefaultComboBoxModel<AttackSoundNotificationsPanel.Condition>(AttackSoundNotificationsPanel.Condition.values()));
        this.replacing.setFocusable(false);
        this.replacing.setToolTipText("When to play the sound");
        this.playing = new JLabel();
        this.playing.setFocusable(false);
        this.playing.setToolTipText("What sound to play");
        this.playing.setText("No sound selected");
        this.playing.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.playing.setForeground(Color.WHITE);
        this.playing.setHorizontalAlignment(0);
        this.playing.setBorder(new EmptyBorder(0, 4, 0, 4));
        this.clearPlaying = new JLabel();
        this.clearPlaying.setIcon(REMOVE_ICON);
        this.clearPlaying.setToolTipText("Clear the custom sound path");
        this.clearPlaying.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JButton testSound = new JButton("Play the sound");
        testSound.setFocusable(false);
        testSound.setToolTipText("Play the selected sound, if it exists");
        JPanel nameWrapper = new JPanel(new BorderLayout());
        nameWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        nameWrapper.setBorder(NAME_BOTTOM_BORDER);
        JPanel nameActions = new JPanel(new BorderLayout(3, 0));
        nameActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel resetOptions = new JPanel(new BorderLayout());
        resetOptions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        final JLabel reset = new JLabel("Reset");
        reset.setFont(FontManager.getRunescapeSmallFont());
        reset.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        reset.setHorizontalAlignment(0);
        this.audible = new JLabel();
        reset.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                boolean shiftHeld = mouseEvent.isShiftDown();
                if (!shiftHeld && JOptionPane.showConfirmDialog(EntryPanel.this, "Reset this sound swap?", "Confirm", 0) != 0) {
                    return;
                }
                EntryPanel.this.setName("Custom Sound " + EntryPanel.this.pluginPanel.entryPanel.getComponentCount());
                EntryPanel.this.nameInput.setText("Custom Sound " + EntryPanel.this.pluginPanel.entryPanel.getComponentCount());
                EntryPanel.this.audible.setIcon(AUDIBLE_ICON);
                EntryPanel.this.setWeaponIcons(DEFAULT_WEAPON_ICON);
                EntryPanel.this.weaponId = -1;
                EntryPanel.this.replacing.setSelectedIndex(0);
                EntryPanel.this.playing.setToolTipText("No sound selected");
                EntryPanel.this.playing.setText("No sound selected");
                EntryPanel.this.pluginPanel.save();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                reset.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                reset.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            }
        });
        this.save.setVisible(false);
        this.save.setFont(FontManager.getRunescapeSmallFont());
        this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.save.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EntryPanel.this.save();
                EntryPanel.this.mainPanel.requestFocusInWindow();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EntryPanel.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EntryPanel.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
            }
        });
        this.cancel.setVisible(false);
        this.cancel.setFont(FontManager.getRunescapeSmallFont());
        this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.cancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EntryPanel.this.cancel();
                EntryPanel.this.mainPanel.requestFocusInWindow();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EntryPanel.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EntryPanel.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }
        });
        this.rename.setFont(FontManager.getRunescapeSmallFont());
        this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        this.rename.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EntryPanel.this.nameInput.setEditable(true);
                EntryPanel.this.updateNameActions(true);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EntryPanel.this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EntryPanel.this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            }
        });
        nameActions.add((Component)this.save, "East");
        nameActions.add((Component)this.cancel, "West");
        nameActions.add((Component)this.rename, "Center");
        this.nameInput.setText(this.getName());
        this.nameInput.setBorder(null);
        this.nameInput.setEditable(false);
        this.nameInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInput.getTextField().setForeground(Color.WHITE);
        this.nameInput.getTextField().setHorizontalAlignment(0);
        this.nameInput.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EntryPanel.this.save();
                    EntryPanel.this.mainPanel.requestFocusInWindow();
                } else if (e.getKeyCode() == 27) {
                    EntryPanel.this.cancel();
                    EntryPanel.this.mainPanel.requestFocusInWindow();
                }
            }
        });
        nameWrapper.add((Component)this.nameInput, "Center");
        nameWrapper.setPreferredSize(new Dimension(200, 20));
        resetOptions.add((Component)reset, "Center");
        this.removeEntry = new JLabel();
        this.removeEntry.setIcon(new ImageIcon(ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/delete.png")));
        this.removeEntry.setToolTipText("Remove this sound");
        this.removeEntry.setBorder(new EmptyBorder(2, 2, 2, 2));
        JPanel removePanel = new JPanel(new BorderLayout());
        removePanel.add((Component)this.removeEntry, "East");
        removePanel.add((Component)nameActions, "West");
        removePanel.add((Component)resetOptions, "Center");
        JPanel weaponIconPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                ImageIcon image = new ImageIcon(ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/weapon_back.png"));
                int x = (this.getWidth() - image.getIconWidth()) / 2;
                int y = (this.getHeight() - image.getIconHeight()) / 2;
                g.drawImage(image.getImage(), x, y, null);
            }
        };
        weaponIconPanel.add((Component)this.weaponLabel, "Center");
        weaponIconPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        weaponIconPanel.setMinimumSize(new Dimension(32, 32));
        weaponIconPanel.setPreferredSize(new Dimension(32, 32));
        weaponIconPanel.setMaximumSize(new Dimension(32, 32));
        JPanel chooserPanel = new JPanel(new BorderLayout());
        chooserPanel.add(this.replacing, "East");
        chooserPanel.add((Component)weaponIconPanel, "West");
        chooserPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)removePanel, "North");
        topPanel.add((Component)chooserPanel, "Center");
        topPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        topPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.audible.setHorizontalAlignment(0);
        this.audible.setToolTipText("Enable/Disable");
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.add((Component)this.audible, "West");
        iconPanel.add((Component)this.playing, "Center");
        iconPanel.add((Component)this.clearPlaying, "East");
        iconPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        iconPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.selectFile = new JLabel();
        this.selectFile.setIcon(OPEN_ICON);
        this.selectFile.setToolTipText("Find the file in on your computer");
        this.textEntry = new JPanel(new BorderLayout());
        this.textEntry.add((Component)new JLabel("Enter your custom sound here:"), "North");
        this.textEntry.add((Component)this.customSoundTextField, "Center");
        this.textEntry.add((Component)this.selectFile, "East");
        this.textEntry.setBorder(new EmptyBorder(5, 8, 5, 8));
        this.textEntry.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel buttons = new JPanel(new BorderLayout());
        buttons.add((Component)this.textEntry, "North");
        buttons.add((Component)testSound, "Center");
        buttons.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel bottomContainer = new JPanel(new BorderLayout());
        bottomContainer.add((Component)topPanel, "North");
        bottomContainer.add((Component)iconPanel, "Center");
        bottomContainer.add((Component)buttons, "South");
        bottomContainer.setBorder(new EmptyBorder(8, 0, 8, 0));
        bottomContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setFocusable(true);
        this.mainPanel.add((Component)nameWrapper, "North");
        this.mainPanel.add((Component)bottomContainer, "South");
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        MatteBorder topRightBorder = new MatteBorder(3, 0, 0, 3, ColorScheme.DARKER_GRAY_COLOR.brighter());
        MatteBorder bottomLeftBorder = new MatteBorder(0, 3, 3, 0, ColorScheme.DARKER_GRAY_COLOR.darker());
        CompoundBorder firstBorder = new CompoundBorder(topRightBorder, emptyBorder);
        CompoundBorder semiFinalBorder = new CompoundBorder(bottomLeftBorder, firstBorder);
        CompoundBorder finalBorder = new CompoundBorder(new EmptyBorder(1, 0, 1, 0), semiFinalBorder);
        this.mainPanel.setBorder(finalBorder);
        this.replacing.setMaximumSize(new Dimension(160, 32));
        this.replacing.setPreferredSize(new Dimension(155, 32));
        this.audible.setIcon(AUDIBLE_ICON);
        this.audible.setCursor(Cursor.getPredefinedCursor(12));
        this.weaponLabel.setIcon(this.weaponIcon);
        weaponIconPanel.setToolTipText("Choose the weapon to play the sound for");
        weaponIconPanel.setCursor(Cursor.getPredefinedCursor(12));
        weaponIconPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EntryPanel.this.plugin.client.getGameState() != GameState.LOGGED_IN) {
                    JOptionPane.showMessageDialog((Component)((Object)EntryPanel.this.pluginPanel), "This plugin uses the in-game item search panel; you must be logged in to use this.", "Log in to choose items", 0);
                    EntryPanel.this.weaponLabel.setIcon(EntryPanel.this.weaponIcon);
                    return;
                }
                EntryPanel.this.plugin.searchProvider.tooltipText("Choose this weapon").onItemSelected(itemId -> {
                    if (itemId == null) {
                        log.warn("Failed to get itemId");
                    } else {
                        EntryPanel.this.weaponId = itemId;
                        EntryPanel.this.setWeaponIcons((BufferedImage)EntryPanel.this.plugin.itemManager.getImage(EntryPanel.this.weaponId.intValue(), 0, false));
                        EntryPanel.this.pluginPanel.save();
                    }
                }).build();
                EntryPanel.this.plugin.chatboxPanelManager.openInput((ChatboxInput)EntryPanel.this.plugin.searchProvider);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EntryPanel.this.weaponLabel.setIcon(DEFAULT_WEAPON_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EntryPanel.this.weaponLabel.setIcon(EntryPanel.this.weaponIcon);
            }
        });
        this.audible.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (EntryPanel.this.audible.getIcon() == AUDIBLE_HOVER_ICON) {
                    EntryPanel.this.audible.setIcon(INAUDIBLE_HOVER_ICON);
                } else {
                    EntryPanel.this.audible.setIcon(AUDIBLE_HOVER_ICON);
                }
                EntryPanel.this.pluginPanel.save();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (EntryPanel.this.audible.getIcon() == AUDIBLE_ICON) {
                    EntryPanel.this.audible.setIcon(AUDIBLE_HOVER_ICON);
                } else {
                    EntryPanel.this.audible.setIcon(INAUDIBLE_HOVER_ICON);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (EntryPanel.this.audible.getIcon() == AUDIBLE_HOVER_ICON) {
                    EntryPanel.this.audible.setIcon(AUDIBLE_ICON);
                } else {
                    EntryPanel.this.audible.setIcon(INAUDIBLE_ICON);
                }
            }
        });
        this.removeEntry.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int confirm;
                boolean shiftHeld = mouseEvent.isShiftDown();
                if (!shiftHeld && (confirm = JOptionPane.showConfirmDialog(EntryPanel.this, "Delete this sound swap?", "Confirm", 0)) != 0) {
                    return;
                }
                EntryPanel.this.pluginPanel.removeEntryPanel(EntryPanel.this);
                EntryPanel.this.pluginPanel.entryPanel.remove(EntryPanel.this.mainPanel);
                EntryPanel.this.pluginPanel.reloadPanels();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EntryPanel.this.removeEntry.setIcon(REMOVE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EntryPanel.this.removeEntry.setIcon(REMOVE_ICON);
            }
        });
        this.replacing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryPanel.this.pluginPanel.save();
            }
        });
        this.clearPlaying.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int confirm;
                boolean shiftHeld = mouseEvent.isShiftDown();
                if (!shiftHeld && (confirm = JOptionPane.showConfirmDialog(EntryPanel.this, "Clear the sound path?", "Confirm", 0)) != 0) {
                    return;
                }
                EntryPanel.this.playing.setText("No sound selected");
                EntryPanel.this.playing.setToolTipText("No sound selected");
                EntryPanel.this.customSoundTextField.setText("");
                EntryPanel.this.save();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EntryPanel.this.clearPlaying.setIcon(REMOVE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EntryPanel.this.clearPlaying.setIcon(REMOVE_ICON);
            }
        });
        this.customSoundTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntryPanel.this.customSoundTextField.getText().endsWith(".wav")) {
                    String text = EntryPanel.this.customSoundTextField.getText();
                    EntryPanel.this.pluginPanel.requestFocusInWindow();
                    String newString = text.contains("\\") ? text.substring(text.lastIndexOf(92) + 1, text.lastIndexOf(46)) : text.substring(text.lastIndexOf(47) + 1, text.lastIndexOf(46));
                    EntryPanel.this.playing.setText(newString);
                    EntryPanel.this.playing.setToolTipText(newString);
                    EntryPanel.this.pluginPanel.save();
                } else {
                    JOptionPane.showMessageDialog(EntryPanel.this, "Acceptable file types: .wav", "Bad file", 0);
                    EntryPanel.this.customSoundTextField.setText("");
                    EntryPanel.this.playing.setText("No sound selected");
                }
            }
        });
        this.selectFile.setCursor(Cursor.getPredefinedCursor(12));
        this.selectFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                fileChooser.setFileFilter(new FileNameExtensionFilter(".wav sound files", "wav"));
                int returnValue = fileChooser.showOpenDialog(null);
                if (returnValue == 0) {
                    String filePath = fileChooser.getSelectedFile().getPath();
                    if (filePath.endsWith(".wav")) {
                        EntryPanel.this.customSoundTextField.setText(filePath);
                        EntryPanel.this.pluginPanel.requestFocusInWindow();
                        String newString = filePath.contains("\\") ? filePath.substring(filePath.lastIndexOf(92) + 1, filePath.lastIndexOf(46)) : filePath.substring(filePath.lastIndexOf(47) + 1, filePath.lastIndexOf(46));
                        EntryPanel.this.playing.setText(newString);
                        EntryPanel.this.playing.setToolTipText(newString);
                        EntryPanel.this.pluginPanel.save();
                    } else {
                        JOptionPane.showMessageDialog(EntryPanel.this, "Acceptable file types: .wav", "Bad file", 0);
                    }
                }
                EntryPanel.this.pluginPanel.reloadPanels();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EntryPanel.this.selectFile.setIcon(OPEN_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EntryPanel.this.selectFile.setIcon(OPEN_ICON);
            }
        });
        testSound.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryPanel.this.pluginPanel.findCustomSound(EntryPanel.this.getCustomSoundPath());
            }
        });
    }

    private void save() {
        this.nameInput.setEditable(false);
        this.updateNameActions(false);
        this.setName(this.nameInput.getText());
        this.pluginPanel.save();
    }

    private void cancel() {
        this.nameInput.setEditable(false);
        this.nameInput.setText(this.getName());
        this.updateNameActions(false);
    }

    private void updateNameActions(boolean saveAndCancel) {
        this.save.setVisible(saveAndCancel);
        this.cancel.setVisible(saveAndCancel);
        this.rename.setVisible(!saveAndCancel);
        if (saveAndCancel) {
            this.nameInput.getTextField().requestFocusInWindow();
            this.nameInput.getTextField().selectAll();
        }
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public int getWeaponId() {
        return this.weaponId;
    }

    public boolean getAudible() {
        return this.audible.getIcon() == AUDIBLE_ICON || this.audible.getIcon() == AUDIBLE_HOVER_ICON;
    }

    public AttackSoundNotificationsPanel.Condition getReplacing() {
        return (AttackSoundNotificationsPanel.Condition)((Object)this.replacing.getSelectedItem());
    }

    public String getWeaponIdString() {
        return Integer.toString(this.weaponId);
    }

    public String getAudibleString() {
        if (this.audible.getIcon() == AUDIBLE_ICON || this.audible.getIcon() == AUDIBLE_HOVER_ICON) {
            return "true";
        }
        return "false";
    }

    public String getCustomSoundPath() {
        return this.customSoundTextField.getText();
    }

    public String getReplacingString() {
        return this.replacing.getSelectedItem().toString();
    }

    private void setWeaponIcons(BufferedImage image) {
        this.weaponIcon = new ImageIcon(image);
        this.weaponLabel.setIcon(this.weaponIcon);
    }

    public void setPanelName(String name) {
        this.setName(name);
        this.nameInput.setText(name);
    }

    public void setWeaponId(String id) {
        this.weaponId = Integer.parseInt(id);
        if (this.weaponId == -1) {
            this.setWeaponIcons(DEFAULT_WEAPON_ICON);
        } else {
            this.setWeaponIcons((BufferedImage)this.plugin.itemManager.getImage(this.weaponId.intValue(), 0, false));
        }
    }

    public void setAudible(String audibleStatus) {
        if (audibleStatus.equals("true")) {
            this.audible.setIcon(AUDIBLE_ICON);
        } else {
            this.audible.setIcon(INAUDIBLE_ICON);
        }
    }

    public void setReplacing(AttackSoundNotificationsPanel.Condition replacingValue) {
        this.replacing.setSelectedItem((Object)replacingValue);
    }

    public void setCustomSoundPath(String customSoundPath) {
        this.customSoundTextField.setText(customSoundPath);
        if (customSoundPath.length() > 4) {
            if (customSoundPath.contains("\\")) {
                this.playing.setText(customSoundPath.substring(customSoundPath.lastIndexOf(92) + 1, customSoundPath.lastIndexOf(46)));
            } else {
                this.playing.setText(customSoundPath.substring(customSoundPath.lastIndexOf(47) + 1, customSoundPath.lastIndexOf(46)));
            }
        }
    }

    static {
        BufferedImage audibleImg = ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/on.png");
        AUDIBLE_ICON = new ImageIcon(audibleImg);
        AUDIBLE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)audibleImg, (int)-100));
        BufferedImage inaudibleImg = ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/off.png");
        INAUDIBLE_HOVER_ICON = new ImageIcon(inaudibleImg);
        INAUDIBLE_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)inaudibleImg, (int)-100));
        BufferedImage removeImg = ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/delete.png");
        REMOVE_ICON = new ImageIcon(removeImg);
        REMOVE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)removeImg, (int)-100));
        BufferedImage openImg = ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/open_icon.png");
        OPEN_ICON = new ImageIcon(openImg);
        BufferedImage openBrightImage = ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/open_bright_icon.png");
        OPEN_HOVER_ICON = new ImageIcon(openBrightImage);
        BufferedImage weaponBackground = ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/weapon_back.png");
        WEAPON_BACKGROUND = new ImageIcon(weaponBackground);
        DEFAULT_WEAPON_ICON = ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/panelIcon.png");
        BufferedImage searchIcon = ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/search.png");
        DEFAULT_WEAPON_HOVER_ICON = new ImageIcon(searchIcon);
    }
}

