/*
 * Decompiled with CFR 0.152.
 */
package com.AttackSoundNotifications.ui;

import com.AttackSoundNotifications.AttackSoundNotificationsPlugin;
import com.AttackSoundNotifications.ui.EntryPanel;
import com.AttackSoundNotifications.ui.EntryPanelState;
import com.google.gson.reflect.TypeToken;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ChatMessageType;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

public class AttackSoundNotificationsPanel
extends PluginPanel {
    private final List<EntryPanel> entryPanelList = new ArrayList<EntryPanel>();
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private final JLabel addSound = new JLabel(ADD_ICON);
    public final JPanel entryPanel = new JPanel(new GridBagLayout());
    private final AttackSoundNotificationsPlugin plugin;
    private Boolean startup = false;

    @Inject
    public AttackSoundNotificationsPanel(AttackSoundNotificationsPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(11, 10, 10, 10));
        JLabel title = new JLabel();
        title.setText("Attack Sound Notifications");
        title.setForeground(Color.WHITE);
        northPanel.add((Component)title, "West");
        northPanel.add((Component)this.addSound, "East");
        this.add(northPanel, "North");
        this.add(this.entryPanel, "South");
        this.addSound.setToolTipText("Add new sound");
        this.addSound.setCursor(Cursor.getPredefinedCursor(12));
        this.addSound.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AttackSoundNotificationsPanel.this.addNewEntry();
                AttackSoundNotificationsPanel.this.save();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                AttackSoundNotificationsPanel.this.addSound.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                AttackSoundNotificationsPanel.this.addSound.setIcon(ADD_ICON);
            }
        });
        this.loadEntryPanels(this.entryPanel);
    }

    public void reloadPanels() {
        this.plugin.clientThread.invokeLater(() -> {
            this.revalidate();
            this.repaint();
        });
    }

    private void addNewEntry() {
        GridBagConstraints entryConstraints = new GridBagConstraints();
        entryConstraints.gridx = 0;
        entryConstraints.weightx = 1.0;
        entryConstraints.fill = 2;
        entryConstraints.anchor = 11;
        EntryPanel newEntryPanel = new EntryPanel(this, this.plugin);
        this.entryPanelList.add(newEntryPanel);
        this.entryPanel.add((Component)newEntryPanel.getMainPanel(), entryConstraints);
        this.reloadPanels();
    }

    private void loadEntryPanels(JPanel parentPanel) {
        this.startup = true;
        List panelStates = (List)this.plugin.gson.fromJson(this.plugin.configManager.getConfiguration("attacknotifications", "attackNotificationsPanel_"), new TypeToken<List<EntryPanelState>>(){}.getType());
        if (panelStates != null) {
            for (EntryPanelState panelState : panelStates) {
                if (panelState.getPanelName() == null) continue;
                EntryPanel newPanel = new EntryPanel(this, this.plugin);
                newPanel.setPanelName(panelState.getPanelName());
                if (panelState.getWeaponId() != null) {
                    newPanel.setWeaponId(panelState.getWeaponId());
                }
                if (panelState.getAudible() != null) {
                    newPanel.setAudible(panelState.getAudible());
                }
                if (panelState.getReplacing() != null) {
                    Condition replacing = Condition.fromString(panelState.getReplacing());
                    newPanel.setReplacing(replacing);
                }
                if (panelState.getCustomSoundPath() != null) {
                    newPanel.setCustomSoundPath(panelState.getCustomSoundPath());
                }
                this.entryPanelList.add(newPanel);
                GridBagConstraints entryConstraints = new GridBagConstraints();
                entryConstraints.gridx = 0;
                entryConstraints.weightx = 1.0;
                entryConstraints.fill = 2;
                entryConstraints.anchor = 18;
                parentPanel.add((Component)newPanel.getMainPanel(), entryConstraints);
            }
            this.startup = false;
        }
    }

    public void save() {
        if (!this.startup.booleanValue()) {
            List panelStates = this.entryPanelList.stream().map(EntryPanelState::new).collect(Collectors.toList());
            this.plugin.configManager.setConfiguration("attacknotifications", "attackNotificationsPanel_", this.plugin.gson.toJson(panelStates));
        }
    }

    public void removeEntryPanel(EntryPanel panel) {
        this.entryPanelList.remove(panel);
        this.save();
    }

    public InputStream fetchSound(Integer hitType, Integer weaponId, Boolean usedSpecialAttack) {
        for (EntryPanel panel : this.entryPanelList) {
            if (weaponId.intValue() != panel.getWeaponId() && panel.getWeaponId() != -1 || !panel.getAudible() || panel.getCustomSoundPath().isEmpty()) continue;
            switch (panel.getReplacing()) {
                case MISS: {
                    if (usedSpecialAttack.booleanValue() || hitType != 12) break;
                    BufferedInputStream returnSound = this.loadCustomSound(panel.getCustomSoundPath());
                    if (returnSound == null) {
                        this.plugin.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Couldn't find custom sound file:" + panel.getCustomSoundPath(), null);
                    }
                    return returnSound;
                }
                case MAX: {
                    if (usedSpecialAttack.booleanValue() || hitType != 43) break;
                    BufferedInputStream returnSound = this.loadCustomSound(panel.getCustomSoundPath());
                    if (returnSound == null) {
                        this.plugin.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Couldn't find custom sound file:" + panel.getCustomSoundPath(), null);
                    }
                    return returnSound;
                }
                case SPECIAL_MISS: {
                    if (!usedSpecialAttack.booleanValue() || hitType != 12) break;
                    BufferedInputStream returnSound = this.loadCustomSound(panel.getCustomSoundPath());
                    if (returnSound == null) {
                        this.plugin.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Couldn't find custom sound file:" + panel.getCustomSoundPath(), null);
                    }
                    return returnSound;
                }
                case SPECIAL_HIT: {
                    if (!usedSpecialAttack.booleanValue() || hitType != 16) break;
                    BufferedInputStream returnSound = this.loadCustomSound(panel.getCustomSoundPath());
                    if (returnSound == null) {
                        this.plugin.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Couldn't find custom sound file:" + panel.getCustomSoundPath(), null);
                    }
                    return returnSound;
                }
                case SPECIAL_MAX: {
                    if (!usedSpecialAttack.booleanValue() || hitType != 43) break;
                    BufferedInputStream returnSound = this.loadCustomSound(panel.getCustomSoundPath());
                    if (returnSound == null) {
                        this.plugin.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Couldn't find custom sound file:" + panel.getCustomSoundPath(), null);
                    }
                    return returnSound;
                }
            }
        }
        return null;
    }

    private BufferedInputStream loadCustomSound(String fileName) {
        try {
            return new BufferedInputStream(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public void findCustomSound(String filePath) {
        BufferedInputStream soundStream = this.loadCustomSound(filePath);
        if (soundStream != null) {
            this.plugin.playCustomSound(soundStream);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static {
        BufferedImage addIcon = ImageUtil.loadImageResource(AttackSoundNotificationsPlugin.class, (String)"/icons/add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (float)0.53f));
    }

    public static enum Condition {
        SPECIAL_HIT("Special Attack Hit"),
        SPECIAL_MISS("Special Attack Miss"),
        SPECIAL_MAX("Special Attack Max"),
        MAX("Non-Special Max"),
        MISS("Non-Special Miss");

        private final String displayValue;

        private Condition(String displayValue) {
            this.displayValue = displayValue;
        }

        public static Condition fromString(String displayValue) {
            for (Condition option : Condition.values()) {
                if (!option.displayValue.equalsIgnoreCase(displayValue)) continue;
                return option;
            }
            return null;
        }

        public String toString() {
            return this.displayValue;
        }
    }
}

