/*
 * Decompiled with CFR 0.152.
 */
package com.AttackSoundNotifications;

import com.AttackSoundNotifications.AttackSoundNotificationsConfig;
import com.AttackSoundNotifications.ui.AttackSoundNotificationsPanel;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Hitsplat;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxItemSearch;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Attack Sound Notifications", description="A plugin that plays sounds based on hitsplats and special attacks", tags={"special", "sounds", "notifications"}, loadWhenOutdated=true, enabledByDefault=true)
public class AttackSoundNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AttackSoundNotificationsPlugin.class);
    public static final String CONFIG_GROUP = "attacknotifications";
    public static final String PANEL_PREFIX = "attackNotificationsPanel_";
    @Inject
    public Client client;
    @Inject
    public AttackSoundNotificationsConfig config;
    @Inject
    public ClientThread clientThread;
    @Inject
    public ClientToolbar clientToolbar;
    @Inject
    public ChatboxItemSearch searchProvider;
    @Inject
    public ChatboxPanelManager chatboxPanelManager;
    @Inject
    public ItemManager itemManager;
    @Inject
    public ConfigManager configManager;
    @Inject
    public Gson gson;
    private AttackSoundNotificationsPanel pluginPanel;
    private Clip clip = null;
    private NavigationButton navButton;
    private int specialPercentage;
    private int specialWeapon;
    private boolean specced = false;

    @Provides
    AttackSoundNotificationsConfig provideConfig(ConfigManager configManager) {
        return (AttackSoundNotificationsConfig)configManager.getConfig(AttackSoundNotificationsConfig.class);
    }

    protected void startUp() throws Exception {
        this.pluginPanel = new AttackSoundNotificationsPanel(this);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icons/panelIcon.png");
        this.navButton = NavigationButton.builder().tooltip("Attack Sounds").icon(icon).priority(5).panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
        log.info("Attack Sounds Notifier started!");
    }

    protected void shutDown() throws Exception {
        this.pluginPanel.save();
        this.clientToolbar.removeNavigation(this.navButton);
        log.info("Attack Sounds Notifier stopped!");
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarpId() != 300) {
            return;
        }
        int specialPercentage = event.getValue();
        if (this.specialPercentage == -1 || specialPercentage >= this.specialPercentage) {
            this.specialPercentage = specialPercentage;
            return;
        }
        this.specialPercentage = specialPercentage;
        this.clientThread.invokeLater(() -> {
            Item weapon;
            ItemContainer equipment;
            if (this.specialWeapon == -1 && (equipment = this.client.getItemContainer(InventoryID.EQUIPMENT)) != null && (weapon = equipment.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx())) != null) {
                this.specialWeapon = weapon.getId();
            }
            this.specced = true;
        });
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Actor target = hitsplatApplied.getActor();
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        if (hitsplat.isMine() && target != this.client.getLocalPlayer()) {
            InputStream soundToPlay;
            Item weapon;
            ItemContainer equipment;
            if (this.specialWeapon == -1 && (equipment = this.client.getItemContainer(InventoryID.EQUIPMENT)) != null && (weapon = equipment.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx())) != null) {
                this.specialWeapon = weapon.getId();
            }
            if ((soundToPlay = this.pluginPanel.fetchSound(hitsplat.getHitsplatType(), this.specialWeapon, this.specced)) != null) {
                this.playCustomSound(soundToPlay);
            }
            this.specialWeapon = -1;
            this.specced = false;
        }
    }

    public synchronized void playCustomSound(InputStream streamName) {
        if (this.clip != null) {
            this.clip.stop();
            this.clip.flush();
            this.clip.close();
            this.clip = null;
        }
        if (streamName != null) {
            try {
                this.clip = AudioSystem.getClip();
            }
            catch (LineUnavailableException e) {
                log.warn("Unable to play sound", (Throwable)e);
                return;
            }
            if (!this.tryLoadCustomSoundFile(streamName)) {
                return;
            }
        }
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float gain = 20.0f * (float)Math.log10((float)this.config.Volume() / 100.0f);
        gain = Math.min(gain, volume.getMaximum());
        gain = Math.max(gain, volume.getMinimum());
        volume.setValue(gain);
        this.clip.start();
    }

    private boolean tryLoadCustomSoundFile(InputStream streamName) {
        boolean bl;
        block8: {
            AudioInputStream sound = AudioSystem.getAudioInputStream(streamName);
            try {
                this.clip.open(sound);
                bl = true;
                if (sound == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sound != null) {
                        try {
                            sound.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                    log.warn("Unable to load sound", (Throwable)e);
                    return false;
                }
            }
            sound.close();
        }
        return bl;
    }
}

