/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runelite.summergarden;

import com.duckblade.runelite.summergarden.ElementalCollisionDetector;
import com.duckblade.runelite.summergarden.SummerGardenConfig;
import com.duckblade.runelite.summergarden.SummerGardenOverlay;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Preferences;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="One Click Summer Garden")
public class SummerGardenPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SummerGardenPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ElementalCollisionDetector collisionDetector;
    @Inject
    private SummerGardenOverlay overlay;
    @Inject
    private SummerGardenConfig config;
    public static final String CONFIG_GROUP = "oneclicksummergarden";
    public static final String CONFIG_KEY_GATE_START = "useGateStartPoint";
    public static final String CONFIG_KEY_COUNTDOWN_TIMER_INFOBOX = "showCountdownTimer";
    public static final String CONFIG_KEY_RACE_STYLE_COUNTDOWN = "raceStyleCountdown";
    public static final String CONFIG_KEY_RACE_STYLE_VOLUME = "raceStyleVolume";
    private static final WorldPoint GARDEN = new WorldPoint(2915, 5490, 0);
    private static final String STAMINA_MESSAGE = "[One Click Summer Garden] Low Stamina Warning";
    private static final String CYCLE_MESSAGE = "[One Click Summer Garden] Cycle Ready";
    private static final int SUMMER_SQUIRK_ITEM_ID = 10845;
    private static final int RACE_STYLE_SOUND_LOW = 3817;
    private static final int RACE_STYLE_SOUND_HIGH = 3818;
    private static final int OBJECT_ID_TREE = 12943;
    private InfoBox countdownTimerInfoBox;
    private boolean sentStaminaNotification = false;
    private GameObject treeObject;
    private boolean overlayEnabled = false;

    protected void startUp() {
        this.enableOverlay();
        if (this.config.showCountdownTimer()) {
            this.enableCountdownTimerInfoBox();
        }
        this.collisionDetector.setGateStart(this.config.useGateStartPoint());
    }

    protected void shutDown() {
        this.disableOverlay();
        this.disableCountdownTimerInfoBox();
    }

    private void enableOverlay() {
        if (this.overlayEnabled) {
            return;
        }
        this.overlayEnabled = true;
        this.overlayManager.add((Overlay)this.overlay);
    }

    private void disableOverlay() {
        if (this.overlayEnabled) {
            this.overlayManager.remove((Overlay)this.overlay);
        }
        this.overlayEnabled = false;
    }

    private void enableCountdownTimerInfoBox() {
        if (this.countdownTimerInfoBox == null) {
            this.countdownTimerInfoBox = new InfoBox((BufferedImage)this.itemManager.getImage(10845), this){

                public String getText() {
                    return String.valueOf(SummerGardenPlugin.this.collisionDetector.getTicksUntilStart());
                }

                public Color getTextColor() {
                    return null;
                }
            };
            this.infoBoxManager.addInfoBox(this.countdownTimerInfoBox);
        }
    }

    private void disableCountdownTimerInfoBox() {
        this.infoBoxManager.removeInfoBox(this.countdownTimerInfoBox);
        this.countdownTimerInfoBox = null;
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        Player p = this.client.getLocalPlayer();
        if (p == null) {
            return;
        }
        if (p.getWorldLocation().distanceTo2D(GARDEN) >= 50) {
            this.disableCountdownTimerInfoBox();
            this.disableOverlay();
            return;
        }
        if (this.config.showCountdownTimer()) {
            this.enableCountdownTimerInfoBox();
        }
        this.enableOverlay();
        this.client.getNpcs().stream().filter(ElementalCollisionDetector::isSummerElemental).forEach(npc -> this.collisionDetector.updatePosition((NPC)npc, this.client.getTickCount()));
        this.collisionDetector.updateCountdownTimer(this.client.getTickCount());
        if (this.config.cycleNotification() && this.collisionDetector.getTicksUntilStart() == this.config.notifyTicksBeforeStart()) {
            this.notifier.notify(CYCLE_MESSAGE, TrayIcon.MessageType.INFO);
        }
        this.playCountdownSounds();
        this.checkStamina();
    }

    private void playCountdownSounds() {
        if (this.config.raceStyleCountdown() && this.collisionDetector.getTicksUntilStart() <= 3 && this.config.raceStyleVolume() > 0) {
            Preferences preferences = this.client.getPreferences();
            int previousVolume = preferences.getSoundEffectVolume();
            preferences.setSoundEffectVolume(this.config.raceStyleVolume());
            if (this.collisionDetector.getTicksUntilStart() == 0) {
                this.client.playSoundEffect(3818, this.config.raceStyleVolume());
            } else {
                this.client.playSoundEffect(3817, this.config.raceStyleVolume());
            }
            preferences.setSoundEffectVolume(previousVolume);
        }
    }

    private void checkStamina() {
        int stamThreshold = this.config.staminaThreshold() * 100;
        if (stamThreshold != 0) {
            boolean stamActive;
            boolean bl = stamActive = this.client.getVarbitValue(25) != 0;
            if (this.client.getEnergy() <= stamThreshold && !stamActive && !this.sentStaminaNotification) {
                this.notifier.notify(STAMINA_MESSAGE, TrayIcon.MessageType.INFO);
                this.sentStaminaNotification = true;
            } else if (this.client.getEnergy() > stamThreshold) {
                this.sentStaminaNotification = false;
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        if (configChanged.getKey().equals(CONFIG_KEY_GATE_START)) {
            this.collisionDetector.setGateStart(this.config.useGateStartPoint());
        } else if (configChanged.getKey().equals(CONFIG_KEY_COUNTDOWN_TIMER_INFOBOX)) {
            if (this.config.showCountdownTimer()) {
                this.enableCountdownTimerInfoBox();
            } else {
                this.disableCountdownTimerInfoBox();
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        if (e.getGameObject().getId() == 12943) {
            this.treeObject = e.getGameObject();
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned e) {
        if (e.getGameObject() == this.treeObject) {
            this.treeObject = null;
        }
    }

    @Provides
    SummerGardenConfig provideConfig(ConfigManager configManager) {
        return (SummerGardenConfig)configManager.getConfig(SummerGardenConfig.class);
    }

    public GameObject getTreeObject() {
        return this.treeObject;
    }
}

