/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runelite.summergarden;

import com.duckblade.runelite.summergarden.ElementalCollisionDetector;
import com.duckblade.runelite.summergarden.ShowNumbers;
import com.duckblade.runelite.summergarden.SummerGardenConfig;
import com.duckblade.runelite.summergarden.SummerGardenPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
public class SummerGardenOverlay
extends Overlay {
    private final Client client;
    private final SummerGardenPlugin plugin;
    private final SummerGardenConfig config;
    private final ElementalCollisionDetector collisionDetector;
    private static final WorldPoint START_POINT_REGULAR_START = new WorldPoint(2908, 5482, 0);
    private static final WorldPoint START_POINT_GATE_START = new WorldPoint(2910, 5481, 0);
    private static final WorldPoint LAUNCH_POINT_REGULAR_START = new WorldPoint(2907, 5485, 0);
    private static final WorldPoint LAUNCH_POINT_GATE_START = new WorldPoint(2907, 5484, 0);

    @Inject
    public SummerGardenOverlay(Client client, SummerGardenPlugin plugin, SummerGardenConfig config, ElementalCollisionDetector collisionDetector) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.collisionDetector = collisionDetector;
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public Dimension render(Graphics2D graphics) {
        this.client.getNpcs().stream().filter(ElementalCollisionDetector::isSummerElemental).forEach(npc -> this.renderNpc((NPC)npc, graphics));
        if (this.config.highlightLaunchTile()) {
            this.renderTile(graphics, this.config.useGateStartPoint() ? START_POINT_GATE_START : START_POINT_REGULAR_START, this.config.highlightLaunch());
            this.renderTile(graphics, this.config.useGateStartPoint() ? LAUNCH_POINT_GATE_START : LAUNCH_POINT_REGULAR_START, this.config.highlightLaunch());
        }
        this.renderTreeCountdown(this.plugin.getTreeObject(), graphics);
        return null;
    }

    private void renderTile(Graphics2D graphics, WorldPoint wp, Color color) {
        Polygon poly;
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)wp);
        if (lp != null && (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp)) != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
        }
    }

    private Color selectColor(int npcId, int parity) {
        if (this.collisionDetector.isLaunchCycle() && (npcId == 1801 || npcId == 1803)) {
            return this.config.highlightLaunch();
        }
        if (parity == 0) {
            return this.config.highlightGood();
        }
        if (parity == -1) {
            return Color.gray;
        }
        return this.config.highlightBad();
    }

    private void renderNpc(NPC npc, Graphics2D graphics) {
        int npcId = npc.getId();
        int parity = this.collisionDetector.getParity(npcId);
        Color highlightColor = this.selectColor(npcId, parity);
        this.renderTile(graphics, npc.getWorldLocation(), highlightColor);
        ShowNumbers numbersConfig = this.config.showNumbers();
        if (numbersConfig == ShowNumbers.YES || parity != 0 && numbersConfig == ShowNumbers.ON_WRONG) {
            String text = parity != -1 ? String.valueOf(parity) : "?";
            Point p2 = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)npc.getLocalLocation(), (String)text, (int)1);
            if (p2 != null) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)p2, (String)text, (Color)highlightColor);
            }
        }
    }

    private void renderTreeCountdown(GameObject tree, Graphics2D graphics) {
        int size = this.config.countdownOnTreeSize();
        if (size == 0 || tree == null) {
            return;
        }
        Shape clickbox = tree.getClickbox();
        if (clickbox == null) {
            return;
        }
        String t = String.valueOf(this.collisionDetector.getTicksUntilStart());
        Font font = graphics.getFont().deriveFont((float)this.config.countdownOnTreeSize());
        int width = graphics.getFontMetrics().stringWidth(t);
        int height = graphics.getFontMetrics().getHeight();
        Rectangle bounds = clickbox.getBounds();
        Point center = new Point((int)bounds.getCenterX() - width / 2, (int)bounds.getCenterY() + height / 2);
        Color color = this.collisionDetector.isLaunchCycle() ? this.config.highlightLaunch() : this.config.highlightGood();
        graphics.setFont(font);
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)clickbox, (Color)color);
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)center, (String)t, (Color)color);
    }
}

