/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runelite.summergarden;

import com.duckblade.runelite.summergarden.ShowNumbers;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="oneclicksummergarden")
public interface SummerGardenConfig
extends Config {
    @ConfigSection(name="Race-Style Countdown", description="Options for the race-style countdown", position=12, closedByDefault=true)
    public static final String raceStyleSection = "raceStyle";

    @ConfigItem(keyName="highlightGood", name="On-Parity Color", description="Color to highlight elementals whose parity is correct.", position=1)
    default public Color highlightGood() {
        return Color.green.darker();
    }

    @ConfigItem(keyName="highlightBad", name="Off-Parity Color", description="Color to highlight elementals whose parity is incorrect.", position=2)
    default public Color highlightBad() {
        return Color.orange;
    }

    @ConfigItem(keyName="highlightLaunch", name="Launch Color", description="Color to highlight elementals when it is time to click the Sq'irk tree.", position=3)
    default public Color highlightLaunch() {
        return Color.decode("#00ADFF");
    }

    @ConfigItem(keyName="highlightLaunchTile", name="Highlight Launch Tile", description="Whether or not to highlight the tile at which the first elemental will be when you click the Sq'irk tree.", position=4)
    default public boolean highlightLaunchTile() {
        return true;
    }

    @ConfigItem(keyName="showNumbers", name="Show Numbers", description="Whether to show numbers on Elementals, showing how many resets will be needed.", position=5)
    default public ShowNumbers showNumbers() {
        return ShowNumbers.YES;
    }

    @ConfigItem(keyName="staminaWarning", name="Low Stamina Threshold", description="What stamina level to warn to use stamina potion (0 to disable).", position=6)
    default public int staminaThreshold() {
        return 25;
    }

    @ConfigItem(keyName="cycleNotification", name="Cycle Notification", description="Whether to send a notification when the launch cycle is starting.", position=7)
    default public boolean cycleNotification() {
        return false;
    }

    @ConfigItem(keyName="notifyTicksBeforeStart", name="Notify ticks before start", description="Requires \"Cycle Notification\" to be enabled. This number controls how many ticks prior to the time you will need to click the tree that the notification is sent.", position=8)
    default public int notifyTicksBeforeStart() {
        return 7;
    }

    @ConfigItem(keyName="showCountdownTimer", name="Show countdown timer", description="Shows a countdown timer infobox for when it is time to start running the maze. Click on the tree when it says \"0\"", position=9)
    @Units(value=" ticks")
    default public boolean showCountdownTimer() {
        return true;
    }

    @ConfigItem(keyName="useGateStartPoint", name="Start on tile after gate", description="Whether to start from the tile you stand on after entering the gate, rather than the normal start tile which is 3 tiles further. This saves the click of having to run to the start tile after clicking the gate.", position=10)
    default public boolean useGateStartPoint() {
        return true;
    }

    @ConfigItem(keyName="countdownOnTreeSize", name="Tree Countdown", description="Font size of a countdown on the tree. Set to 0 to disable.", position=11)
    default public int countdownOnTreeSize() {
        return 0;
    }

    @ConfigItem(keyName="raceStyleCountdown", name="Enable race-style countdown", description="Plays race-style countdown sounds on the last few ticks before and when the player needs to click the tree.", position=1, section="raceStyle")
    default public boolean raceStyleCountdown() {
        return false;
    }

    @Range(max=127)
    @ConfigItem(keyName="raceStyleVolume", name="Race-style volume", description="Configures the volume of the race-style countdown sounds.", position=2, section="raceStyle")
    default public int raceStyleVolume() {
        return 96;
    }
}

