/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runelite.summergarden;

import java.util.Arrays;
import javax.inject.Singleton;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;

@Singleton
public class ElementalCollisionDetector {
    private static final WorldPoint[] HOMES = new WorldPoint[]{new WorldPoint(2907, 5488, 0), new WorldPoint(2907, 5490, 0), new WorldPoint(2910, 5487, 0), new WorldPoint(2912, 5485, 0), new WorldPoint(2921, 5486, 0), new WorldPoint(2921, 5495, 0)};
    private static final int[] CYCLE_LENGTHS = new int[]{10, 10, 12, 20, 12, 12};
    private boolean gateStart;
    private final int[] tickBasis = new int[]{-1, -1, -1, -1, -1, -1};
    private int ticksUntilStart = -1;
    static final boolean[][] VALID_TICKS_NORMAL_START = new boolean[][]{{false, false, false, false, false, false, false, true, false, false}, {false, false, false, true, false, false, false, false, true, false}, {true, false, false, false, false, true, true, true, false, false, false, false}, {true, true, true, true, false, false, false, true, true, true, true, false, false, true, false, false, false, false, false, true}, {false, false, true, false, false, false, false, false, true, false, false, false}, {true, false, false, false, true, false, true, true, true, true, true, true}};
    static final boolean[][] VALID_TICKS_GATE_START = new boolean[][]{{false, false, false, false, false, false, true, false, false, false}, {true, true, true, false, false, false, false, true, false, false}, {false, false, true, true, true, true, false, false, false, false, true, true}, {true, true, true, false, false, false, true, true, true, true, true, true, false, false, false, false, false, true, true, true}, {true, false, true, false, false, false, true, false, false, false, false, true}, {false, false, false, true, false, false, true, true, true, true, true, false}};

    private boolean[] getValidTicksForElemental(int elementalIndex) {
        return this.gateStart ? VALID_TICKS_GATE_START[elementalIndex] : VALID_TICKS_NORMAL_START[elementalIndex];
    }

    public static boolean isSummerElemental(NPC npc) {
        return npc.getId() >= 1801 && npc.getId() <= 1806;
    }

    public void updatePosition(NPC npc, int tc) {
        if (!ElementalCollisionDetector.isSummerElemental(npc)) {
            return;
        }
        int eId = npc.getId() - 1801;
        if (npc.getWorldLocation().equals((Object)HOMES[eId])) {
            this.tickBasis[eId] = tc;
        }
    }

    public void updateCountdownTimer(int tc) {
        this.ticksUntilStart = ElementalCollisionDetector.moduloPositive(this.getBestStartPointForLowestTotalParityScore() - tc, 60);
    }

    int getBestStartPointForLowestTotalParityScore() {
        int smallestParity = Integer.MAX_VALUE;
        int smallestParityIndex = -1;
        for (int i = 0; i < 60; ++i) {
            int paritySum = this.getParitySum(i);
            if (paritySum >= smallestParity) continue;
            smallestParity = paritySum;
            smallestParityIndex = i;
        }
        if (smallestParityIndex == -1) {
            throw new IllegalStateException("Every elemental should be passable on at least one tick.");
        }
        return smallestParityIndex;
    }

    int getParitySum(int startCycle) {
        int paritySum = 0;
        for (int elementalIndex = 0; elementalIndex < 6; ++elementalIndex) {
            paritySum += this.getParityForStartCycle(startCycle, elementalIndex);
        }
        return paritySum;
    }

    private int getParityForStartCycle(int startCycle, int elementalIndex) {
        if (this.tickBasis[elementalIndex] == -1) {
            return -1;
        }
        int basis = this.tickBasis[elementalIndex];
        boolean[] validTicksForElemental = this.getValidTicksForElemental(elementalIndex);
        for (int parity = 0; parity < validTicksForElemental.length; ++parity) {
            int cycleLength = CYCLE_LENGTHS[elementalIndex];
            int indexWithParity = ElementalCollisionDetector.moduloPositive(startCycle - basis - parity, cycleLength);
            if (!validTicksForElemental[indexWithParity]) continue;
            return parity;
        }
        throw new IllegalStateException("Every elemental should be passable on at least one tick.");
    }

    public int getParity(int elementalId) {
        boolean seenAllElementalBasis = !Arrays.stream(this.tickBasis).filter(i -> i == -1).findAny().isPresent();
        return !seenAllElementalBasis ? -1 : this.getParityForStartCycle(this.getBestStartPointForLowestTotalParityScore(), elementalId - 1801);
    }

    public boolean isLaunchCycle() {
        return this.ticksUntilStart < 8;
    }

    private static int moduloPositive(int base, int mod) {
        return (base % mod + mod) % mod;
    }

    public void setGateStart(boolean gateStart) {
        this.gateStart = gateStart;
    }

    public int getTicksUntilStart() {
        return this.ticksUntilStart;
    }
}

