/*
 * Decompiled with CFR 0.152.
 */
package com.worldfinder.WorldFinder;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import net.runelite.http.api.worlds.WorldType;

enum WorldTypeFilter {
    NORMAL{

        @Override
        boolean matches(Set<WorldType> types) {
            EnumSet<WorldType> normal = EnumSet.of(WorldType.MEMBERS, WorldType.LAST_MAN_STANDING, WorldType.SKILL_TOTAL);
            EnumSet<WorldType> inverse = EnumSet.complementOf(normal);
            return Sets.intersection(types, inverse).isEmpty();
        }
    }
    ,
    DEADMAN{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains(WorldType.DEADMAN);
        }
    }
    ,
    SEASONAL{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains(WorldType.SEASONAL);
        }
    }
    ,
    QUEST_SPEEDRUNNING{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains(WorldType.QUEST_SPEEDRUNNING);
        }
    }
    ,
    FRESH_START_WORLD{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains(WorldType.FRESH_START_WORLD);
        }
    }
    ,
    PVP{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains(WorldType.PVP);
        }
    }
    ,
    TARGET{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains(WorldType.BOUNTY);
        }
    }
    ,
    HIGH_RISK{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains(WorldType.HIGH_RISK) && !types.contains(WorldType.PVP);
        }
    }
    ,
    SKILL_TOTAL{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains(WorldType.SKILL_TOTAL);
        }
    };


    abstract boolean matches(Set<WorldType> var1);
}

