/*
 * Decompiled with CFR 0.152.
 */
package com.worldfinder.WorldFinder;

import com.google.common.collect.Ordering;
import com.worldfinder.WorldFinder.RegionFilterMode;
import com.worldfinder.WorldFinder.SkillTotalFilter;
import com.worldfinder.WorldFinder.SubscriptionFilterMode;
import com.worldfinder.WorldFinder.WorldFinderPlugin;
import com.worldfinder.WorldFinder.WorldTableHeader;
import com.worldfinder.WorldFinder.WorldTableRow;
import com.worldfinder.WorldFinder.WorldTypeFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;

class WorldSwitcherPanel
extends PluginPanel {
    private static final Color ODD_ROW = new Color(44, 44, 44);
    private static final int WORLD_COLUMN_WIDTH = 50;
    private static final int PLAYERS_COLUMN_WIDTH = 30;
    private static final int PING_COLUMN_WIDTH = 43;
    private static final int TIMER_COLUMN_WIDTH = 45;
    private final JPanel listContainer = new JPanel();
    private WorldTableHeader worldHeader;
    private WorldTableHeader playersHeader;
    private WorldTableHeader activityHeader;
    private WorldTableHeader timerHeader;
    private WorldTableHeader pingHeader;
    private WorldOrder orderIndex = WorldOrder.WORLD;
    private boolean ascendingOrder = true;
    public final ArrayList<WorldTableRow> rows = new ArrayList();
    private final WorldFinderPlugin plugin;
    private SubscriptionFilterMode subscriptionFilterMode;
    private Set<RegionFilterMode> regionFilterMode;
    private Set<WorldTypeFilter> worldTypeFilters;
    private Boolean twelveHourFormat;
    private int pingFilter;
    private Set<SkillTotalFilter> skillTotalFilters;

    WorldSwitcherPanel(WorldFinderPlugin plugin) {
        this.plugin = plugin;
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JPanel headerContainer = this.buildHeader();
        this.listContainer.setLayout(new GridLayout(0, 1));
        this.add(headerContainer);
        this.add(this.listContainer);
    }

    void switchCurrentHighlight(int newWorld, int lastWorld) {
        for (WorldTableRow row : this.rows) {
            if (row.getWorld().getId() == newWorld) {
                row.recolour(true);
                continue;
            }
            if (row.getWorld().getId() != lastWorld) continue;
            row.recolour(false);
        }
    }

    void updateListData(Map<Integer, Integer> worldData) {
        for (WorldTableRow worldTableRow : this.rows) {
            World world = worldTableRow.getWorld();
            Integer playerCount = worldData.get(world.getId());
            if (playerCount == null) continue;
            worldTableRow.updatePlayerCount(playerCount);
        }
        if (this.orderIndex == WorldOrder.PLAYERS) {
            this.updateList();
        }
    }

    void updatePing(int world, int ping) {
        for (WorldTableRow worldTableRow : this.rows) {
            if (worldTableRow.getWorld().getId() != world) continue;
            worldTableRow.setPing(ping);
            if (this.orderIndex != WorldOrder.PING) break;
            this.updateList();
            break;
        }
    }

    void hidePing() {
        for (WorldTableRow worldTableRow : this.rows) {
            worldTableRow.hidePing();
        }
    }

    void showPing() {
        for (WorldTableRow worldTableRow : this.rows) {
            worldTableRow.showPing();
        }
    }

    void updateList() {
        this.rows.sort((r1, r2) -> {
            switch (this.orderIndex) {
                case PING: {
                    return this.getCompareValue((WorldTableRow)r1, (WorldTableRow)r2, row -> {
                        int ping = row.getPing();
                        return ping > 0 ? Integer.valueOf(ping) : null;
                    });
                }
                case WORLD: {
                    return this.getCompareValue((WorldTableRow)r1, (WorldTableRow)r2, row -> Integer.valueOf(row.getWorld().getId()));
                }
                case PLAYERS: {
                    return this.getCompareValue((WorldTableRow)r1, (WorldTableRow)r2, WorldTableRow::getUpdatedPlayerCount);
                }
                case ACTIVITY: {
                    return this.getCompareValue((WorldTableRow)r1, (WorldTableRow)r2, row -> {
                        String activity = row.getWorld().getActivity();
                        return !activity.equals("-") ? activity : null;
                    });
                }
                case TIMER: {
                    return this.getCompareValue((WorldTableRow)r1, (WorldTableRow)r2, row -> {
                        Long timer = row.getTimer();
                        return Long.valueOf(timer != null ? timer : 0L);
                    });
                }
            }
            return 0;
        });
        this.rows.sort((r1, r2) -> {
            boolean b1 = this.plugin.isFavorite(r1.getWorld());
            boolean b2 = this.plugin.isFavorite(r2.getWorld());
            return Boolean.compare(b2, b1);
        });
        this.listContainer.removeAll();
        for (int i = 0; i < this.rows.size(); ++i) {
            WorldTableRow row = this.rows.get(i);
            row.setBackground(i % 2 == 0 ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
            this.listContainer.add(row);
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    private int getCompareValue(WorldTableRow row1, WorldTableRow row2, Function<WorldTableRow, Comparable> compareByFn) {
        Ordering ordering = Ordering.natural();
        if (!this.ascendingOrder) {
            ordering = ordering.reverse();
        }
        ordering = ordering.nullsLast();
        return ordering.compare((Object)compareByFn.apply(row1), (Object)compareByFn.apply(row2));
    }

    void updateFavoriteMenu(int world, boolean favorite) {
        for (WorldTableRow row : this.rows) {
            if (row.getWorld().getId() != world) continue;
            row.setFavoriteMenu(favorite);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void populate(List<World> worlds) {
        this.rows.clear();
        int i = 0;
        while (true) {
            block11: {
                World world;
                block13: {
                    String activity;
                    Integer ping;
                    block12: {
                        if (i >= worlds.size()) {
                            this.updateList();
                            return;
                        }
                        world = worlds.get(i);
                        switch (this.subscriptionFilterMode) {
                            case FREE: {
                                if (!world.getTypes().contains(WorldType.MEMBERS)) break;
                                break block11;
                            }
                            case MEMBERS: {
                                if (!world.getTypes().contains(WorldType.MEMBERS)) break block11;
                            }
                        }
                        if (!this.regionFilterMode.isEmpty() && !this.regionFilterMode.contains((Object)RegionFilterMode.of(world.getRegion()))) break block11;
                        if (this.worldTypeFilters.isEmpty()) break block12;
                        boolean matches = false;
                        for (WorldTypeFilter worldTypeFilter : this.worldTypeFilters) {
                            matches |= worldTypeFilter.matches(world.getTypes());
                        }
                        if (!matches) break block11;
                    }
                    if (this.pingFilter != 0 && ((ping = this.plugin.getStoredPing(world)) == null || ping > this.pingFilter)) break block11;
                    if (this.skillTotalFilters.isEmpty() || !(activity = world.getActivity()).contains("skill total")) break block13;
                    boolean filter = true;
                    for (SkillTotalFilter skillTotalFilter : this.skillTotalFilters) {
                        if (!activity.equals(skillTotalFilter.getSkillTotal())) continue;
                        filter = false;
                        break;
                    }
                    if (filter) break block11;
                }
                this.rows.add(this.buildRow(world, i % 2 == 0, world.getId() == this.plugin.getCurrentWorld() && this.plugin.getLastWorld() != 0, this.plugin.isFavorite(world), this.twelveHourFormat));
            }
            ++i;
        }
    }

    private void orderBy(WorldOrder order) {
        this.pingHeader.highlight(false, this.ascendingOrder);
        this.worldHeader.highlight(false, this.ascendingOrder);
        this.playersHeader.highlight(false, this.ascendingOrder);
        this.activityHeader.highlight(false, this.ascendingOrder);
        this.timerHeader.highlight(false, this.ascendingOrder);
        switch (order) {
            case PING: {
                this.pingHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case WORLD: {
                this.worldHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case PLAYERS: {
                this.playersHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case ACTIVITY: {
                this.activityHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case TIMER: {
                this.timerHeader.highlight(true, this.ascendingOrder);
            }
        }
        this.orderIndex = order;
        this.updateList();
    }

    private JPanel buildHeader() {
        JPanel header = new JPanel(new BorderLayout());
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        this.pingHeader = new WorldTableHeader("Ping", this.orderIndex == WorldOrder.PING, this.ascendingOrder, this.plugin::refresh);
        this.pingHeader.setPreferredSize(new Dimension(43, 0));
        this.pingHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.PING || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.PING);
            }
        });
        this.worldHeader = new WorldTableHeader("World", this.orderIndex == WorldOrder.WORLD, this.ascendingOrder, this.plugin::refresh);
        this.worldHeader.setPreferredSize(new Dimension(50, 0));
        this.worldHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.WORLD || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.WORLD);
            }
        });
        this.playersHeader = new WorldTableHeader("#", this.orderIndex == WorldOrder.PLAYERS, this.ascendingOrder, this.plugin::refresh);
        this.playersHeader.setPreferredSize(new Dimension(30, 0));
        this.playersHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.PLAYERS || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.PLAYERS);
            }
        });
        this.activityHeader = new WorldTableHeader("Activity", this.orderIndex == WorldOrder.ACTIVITY, this.ascendingOrder, this.plugin::refresh);
        this.activityHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.ACTIVITY || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.ACTIVITY);
            }
        });
        this.timerHeader = new WorldTableHeader("Time", this.orderIndex == WorldOrder.TIMER, this.ascendingOrder, this.plugin::refresh);
        this.timerHeader.setPreferredSize(new Dimension(45, 0));
        this.timerHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.TIMER || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.TIMER);
            }
        });
        leftSide.add((Component)this.worldHeader, "West");
        leftSide.add((Component)this.playersHeader, "Center");
        leftSide.add((Component)this.timerHeader, "East");
        rightSide.add((Component)this.activityHeader, "Center");
        rightSide.add((Component)this.pingHeader, "East");
        header.add((Component)leftSide, "West");
        header.add((Component)rightSide, "Center");
        return header;
    }

    private WorldTableRow buildRow(World world, boolean stripe, boolean current, boolean favorite, boolean twelveHourFormat) {
        WorldTableRow row = new WorldTableRow(world, current, favorite, twelveHourFormat, this.plugin.getStoredPing(world), this.plugin.getTimer(world.getId()), this.plugin::hopTo, (world12, add) -> {
            if (add.booleanValue()) {
                this.plugin.addToFavorites((World)world12);
            } else {
                this.plugin.removeFromFavorites((World)world12);
            }
            this.updateList();
        });
        row.setBackground(stripe ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
        return row;
    }

    void setSubscriptionFilterMode(SubscriptionFilterMode subscriptionFilterMode) {
        this.subscriptionFilterMode = subscriptionFilterMode;
    }

    void setRegionFilterMode(Set<RegionFilterMode> regionFilterMode) {
        this.regionFilterMode = regionFilterMode;
    }

    void setWorldTypeFilters(Set<WorldTypeFilter> worldTypeFilters) {
        this.worldTypeFilters = worldTypeFilters;
    }

    void setTwelveHourFormat(Boolean twelveHourFormat) {
        this.twelveHourFormat = twelveHourFormat;
    }

    void setPingFilter(int pingFilter) {
        this.pingFilter = pingFilter;
    }

    void setSkillTotalFilters(Set<SkillTotalFilter> skillTotalFilters) {
        this.skillTotalFilters = skillTotalFilters;
    }

    private static enum WorldOrder {
        WORLD,
        PLAYERS,
        ACTIVITY,
        PING,
        TIMER;

    }
}

