/*
 * Decompiled with CFR 0.152.
 */
package com.worldfinder.WorldFinder;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import com.worldfinder.WorldFinder.WorldFinderConfig;
import com.worldfinder.WorldFinder.WorldHopperPingOverlay;
import com.worldfinder.WorldFinder.WorldSwitcherPanel;
import com.worldfinder.WorldFinder.WorldTableRow;
import com.worldfinder.WorldFinder.WorldTimerUpdate;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.ChatPlayer;
import net.runelite.api.Client;
import net.runelite.api.FriendContainer;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.World;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WorldListLoad;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.WorldsFetch;
import net.runelite.client.game.WorldService;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.worldhopper.ping.Ping;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ExecutorServiceExceptionLogger;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldResult;
import net.runelite.http.api.worlds.WorldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="World Finder", description="Allows you to quickly hop worlds", tags={"ping", "switcher"}, conflicts={"World Hopper"})
public class WorldFinderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WorldFinderPlugin.class);
    private static final int REFRESH_THROTTLE = 60000;
    private static final int MAX_PLAYER_COUNT = 1950;
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    private static final String HOP_TO = "Hop-to";
    private static final String KICK_OPTION = "Kick";
    private static final ImmutableList<String> BEFORE_OPTIONS = ImmutableList.of((Object)"Add friend", (Object)"Remove friend", (Object)"Kick");
    private static final ImmutableList<String> AFTER_OPTIONS = ImmutableList.of((Object)"Message");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private WorldFinderConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WorldHopperPingOverlay worldHopperOverlay;
    @Inject
    private WorldService worldService;
    @Inject
    private PartyService partyService;
    @Inject
    private WSClient wsClient;
    private ScheduledExecutorService hopperExecutorService;
    private NavigationButton navButton;
    private WorldSwitcherPanel panel;
    private World quickHopTargetWorld;
    private int displaySwitcherAttempts = 0;
    private int lastWorld;
    private int favoriteWorld1;
    private int favoriteWorld2;
    private ScheduledFuture<?> pingFuture;
    private ScheduledFuture<?> currPingFuture;
    private int currentWorld;
    private Instant lastFetch;
    private int currentPing;
    private final Map<Integer, Integer> storedPings = new HashMap<Integer, Integer>();
    private final Map<Integer, Long> storedTimers = new HashMap<Integer, Long>();
    private final HotkeyListener previousKeyListener = new HotkeyListener(() -> this.config.previousKey()){

        public void hotkeyPressed() {
            WorldFinderPlugin.this.clientThread.invoke(() -> WorldFinderPlugin.this.hop(true));
        }
    };
    private final HotkeyListener nextKeyListener = new HotkeyListener(() -> this.config.nextKey()){

        public void hotkeyPressed() {
            WorldFinderPlugin.this.clientThread.invoke(() -> WorldFinderPlugin.this.hop(false));
        }
    };

    @Provides
    WorldFinderConfig getConfig(ConfigManager configManager) {
        return (WorldFinderConfig)configManager.getConfig(WorldFinderConfig.class);
    }

    protected void startUp() throws Exception {
        this.wsClient.registerMessage(WorldTimerUpdate.class);
        this.currentPing = -1;
        this.keyManager.registerKeyListener((KeyListener)this.previousKeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.nextKeyListener);
        this.panel = new WorldSwitcherPanel(this);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/world_finder_icon.png");
        this.navButton = NavigationButton.builder().tooltip("World Finder").icon(icon).priority(3).panel((PluginPanel)this.panel).build();
        if (this.config.showSidebar()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
        this.overlayManager.add((Overlay)this.worldHopperOverlay);
        this.panel.setSubscriptionFilterMode(this.config.subscriptionFilter());
        this.panel.setRegionFilterMode(this.config.regionFilter());
        this.panel.setWorldTypeFilters(this.config.worldTypeFilter());
        this.panel.setTwelveHourFormat(this.config.twelveHourTime());
        this.panel.setPingFilter(this.config.pingFilter());
        this.panel.setSkillTotalFilters(this.config.skillTotalFilter());
        this.hopperExecutorService = new ExecutorServiceExceptionLogger(Executors.newSingleThreadScheduledExecutor());
        this.hopperExecutorService.execute(this::pingInitialWorlds);
        this.pingFuture = this.hopperExecutorService.scheduleWithFixedDelay(this::pingNextWorld, 15L, 3L, TimeUnit.SECONDS);
        this.currPingFuture = this.hopperExecutorService.scheduleWithFixedDelay(this::pingCurrentWorld, 15L, 1L, TimeUnit.SECONDS);
        this.updateList();
    }

    protected void shutDown() throws Exception {
        this.wsClient.unregisterMessage(WorldTimerUpdate.class);
        this.pingFuture.cancel(true);
        this.pingFuture = null;
        this.currPingFuture.cancel(true);
        this.currPingFuture = null;
        this.overlayManager.remove((Overlay)this.worldHopperOverlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.previousKeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.nextKeyListener);
        this.clientToolbar.removeNavigation(this.navButton);
        this.hopperExecutorService.shutdown();
        this.hopperExecutorService = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("worldfinder")) {
            switch (event.getKey()) {
                case "showSidebar": {
                    if (this.config.showSidebar()) {
                        this.clientToolbar.addNavigation(this.navButton);
                        break;
                    }
                    this.clientToolbar.removeNavigation(this.navButton);
                    break;
                }
                case "ping": {
                    if (this.config.ping()) {
                        SwingUtilities.invokeLater(() -> this.panel.showPing());
                        break;
                    }
                    SwingUtilities.invokeLater(() -> this.panel.hidePing());
                    break;
                }
                case "subscriptionFilter": {
                    this.panel.setSubscriptionFilterMode(this.config.subscriptionFilter());
                    this.updateList();
                    break;
                }
                case "regionFilter": {
                    this.panel.setRegionFilterMode(this.config.regionFilter());
                    this.updateList();
                    break;
                }
                case "worldTypeFilter": {
                    this.panel.setWorldTypeFilters(this.config.worldTypeFilter());
                    this.updateList();
                    break;
                }
                case "twelveHourTime": {
                    this.panel.setTwelveHourFormat(this.config.twelveHourTime());
                    this.updateList();
                    break;
                }
                case "pingFilter": {
                    this.panel.setPingFilter(this.config.pingFilter());
                    this.updateList();
                    break;
                }
                case "skillTotalFilter": {
                    this.panel.setSkillTotalFilters(this.config.skillTotalFilter());
                    this.updateList();
                }
            }
        }
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if ("hop".equals(commandExecuted.getCommand())) {
            int worldNumber;
            try {
                String[] arguments = commandExecuted.getArguments();
                worldNumber = Integer.parseInt(arguments[0]);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).value("Usage: ::hop world").build());
                return;
            }
            net.runelite.http.api.worlds.World world = this.worldService.getWorlds().findWorld(worldNumber);
            if (world == null) {
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).value("Unknown world " + worldNumber).build());
                return;
            }
            this.hop(world);
        }
    }

    private void setFavoriteConfig(int world) {
        this.configManager.setConfiguration("worldfinder", "favorite_" + world, (Object)true);
    }

    private boolean isFavoriteConfig(int world) {
        Boolean favorite = (Boolean)this.configManager.getConfiguration("worldfinder", "favorite_" + world, Boolean.class);
        return favorite != null && favorite != false;
    }

    private void clearFavoriteConfig(int world) {
        this.configManager.unsetConfiguration("worldfinder", "favorite_" + world);
    }

    boolean isFavorite(net.runelite.http.api.worlds.World world) {
        int id = world.getId();
        return id == this.favoriteWorld1 || id == this.favoriteWorld2 || this.isFavoriteConfig(id);
    }

    int getCurrentWorld() {
        return this.client.getWorld();
    }

    void addToFavorites(net.runelite.http.api.worlds.World world) {
        log.debug("Adding world {} to favorites", (Object)world.getId());
        this.setFavoriteConfig(world.getId());
        this.panel.updateFavoriteMenu(world.getId(), true);
    }

    void removeFromFavorites(net.runelite.http.api.worlds.World world) {
        log.debug("Removing world {} from favorites", (Object)world.getId());
        this.clearFavoriteConfig(world.getId());
        this.panel.updateFavoriteMenu(world.getId(), false);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (varbitChanged.getVarbitId() == 4597 || varbitChanged.getVarbitId() == 4598) {
            this.favoriteWorld1 = this.client.getVarbitValue(4597);
            this.favoriteWorld2 = this.client.getVarbitValue(4598);
            SwingUtilities.invokeLater(this.panel::updateList);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.config.menuOption()) {
            return;
        }
        int componentId = event.getActionParam1();
        int groupId = WidgetInfo.TO_GROUP((int)componentId);
        String option = event.getOption();
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() || groupId == WidgetInfo.FRIENDS_CHAT.getGroupId() || componentId == WidgetInfo.CLAN_MEMBER_LIST.getId() || componentId == WidgetInfo.CLAN_GUEST_MEMBER_LIST.getId()) {
            boolean after;
            if (AFTER_OPTIONS.contains((Object)option)) {
                after = true;
            } else if (BEFORE_OPTIONS.contains((Object)option)) {
                after = false;
            } else {
                return;
            }
            ChatPlayer player = this.getChatPlayerFromName(event.getTarget());
            WorldResult worldResult = this.worldService.getWorlds();
            if (player == null || player.getWorld() == 0 || player.getWorld() == this.client.getWorld() || worldResult == null) {
                return;
            }
            net.runelite.http.api.worlds.World currentWorld = worldResult.findWorld(this.client.getWorld());
            net.runelite.http.api.worlds.World targetWorld = worldResult.findWorld(player.getWorld());
            if (targetWorld == null || currentWorld == null || !currentWorld.getTypes().contains(WorldType.PVP) && targetWorld.getTypes().contains(WorldType.PVP)) {
                return;
            }
            this.client.createMenuEntry(after ? -2 : -1).setOption(HOP_TO).setTarget(event.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> {
                ChatPlayer p = this.getChatPlayerFromName(e.getTarget());
                if (p != null) {
                    this.hop(p.getWorld());
                }
            });
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (this.config.showSidebar() && gameStateChanged.getGameState() == GameState.LOGGED_IN && this.lastWorld != this.client.getWorld()) {
            int newWorld = this.client.getWorld();
            this.setTimer(this.lastWorld);
            this.setTimer(newWorld);
            if (this.partyService.isInParty()) {
                this.partyService.send((PartyMessage)new WorldTimerUpdate(this.lastWorld, this.getTimer(this.lastWorld)));
                this.partyService.send((PartyMessage)new WorldTimerUpdate(newWorld, this.getTimer(newWorld)));
            }
            this.panel.switchCurrentHighlight(newWorld, this.lastWorld);
            this.lastWorld = newWorld;
            this.updateList();
        }
    }

    @Subscribe
    public void onWorldTimerUpdate(WorldTimerUpdate update) {
        this.storedTimers.put(update.getWorldId(), update.getTimeStamp());
        this.updateList();
    }

    @Subscribe
    public void onWorldListLoad(WorldListLoad worldListLoad) {
        if (!this.config.showSidebar()) {
            return;
        }
        HashMap<Integer, Integer> worldData = new HashMap<Integer, Integer>();
        for (World w : worldListLoad.getWorlds()) {
            worldData.put(w.getId(), w.getPlayerCount());
        }
        this.panel.updateListData(worldData);
        this.lastFetch = Instant.now();
    }

    void refresh() {
        Instant now = Instant.now();
        if (this.lastFetch != null && now.toEpochMilli() - this.lastFetch.toEpochMilli() < 60000L) {
            log.debug("Throttling world refresh");
            return;
        }
        this.lastFetch = now;
        this.worldService.refresh();
    }

    @Subscribe
    public void onWorldsFetch(WorldsFetch worldsFetch) {
        this.updateList();
    }

    private void updateList() {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult != null) {
            SwingUtilities.invokeLater(() -> this.panel.populate(worldResult.getWorlds()));
        }
    }

    private void hop(boolean previous) {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null || this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        net.runelite.http.api.worlds.World currentWorld = worldResult.findWorld(this.client.getWorld());
        if (currentWorld == null) {
            return;
        }
        int worldIdx = 0;
        for (WorldTableRow row : this.panel.rows) {
            if (currentWorld != row.getWorld()) continue;
            worldIdx = this.panel.rows.indexOf(row);
        }
        int totalLevel = this.client.getTotalLevel();
        net.runelite.http.api.worlds.World newWorld = currentWorld;
        for (int i = 0; i < this.panel.rows.size(); ++i) {
            net.runelite.http.api.worlds.World world;
            if (previous) {
                if (--worldIdx < 0) {
                    worldIdx = this.panel.rows.size() - 1;
                }
            } else if (++worldIdx >= this.panel.rows.size()) {
                worldIdx = 0;
            }
            if ((world = this.panel.rows.get(worldIdx).getWorld()).getPlayers() >= 1950) continue;
            if (world.getTypes().contains(WorldType.SKILL_TOTAL)) {
                try {
                    int totalRequirement = Integer.parseInt(world.getActivity().substring(0, world.getActivity().indexOf(" ")));
                    if (totalLevel < totalRequirement) {
                        continue;
                    }
                }
                catch (NumberFormatException ex) {
                    log.warn("Failed to parse total level requirement for target world", (Throwable)ex);
                }
            }
            if (world.getPlayers() < 0 || this.config.quickhopOutOfDanger() && (world.getTypes().contains(WorldType.HIGH_RISK) || world.getTypes().contains(WorldType.PVP))) continue;
            newWorld = world;
            break;
        }
        if (newWorld == currentWorld) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Couldn't find a world to quick-hop to. Check the World Finder panel to see if too many worlds are being filtered.").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        } else {
            this.hop(newWorld.getId());
        }
    }

    private void hop(int worldId) {
        WorldResult worldResult = this.worldService.getWorlds();
        net.runelite.http.api.worlds.World world = worldResult.findWorld(worldId);
        if (world == null) {
            return;
        }
        this.hop(world);
    }

    void hopTo(net.runelite.http.api.worlds.World world) {
        this.clientThread.invoke(() -> this.hop(world));
    }

    private void hop(net.runelite.http.api.worlds.World world) {
        assert (this.client.isClientThread());
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeWorld(rsWorld);
            return;
        }
        if (this.config.showWorldHopMessage()) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Quick-hopping to World ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world.getId())).append(ChatColorType.NORMAL).append("..").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        }
        this.quickHopTargetWorld = rsWorld;
        this.displaySwitcherAttempts = 0;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.quickHopTargetWorld == null) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.client.openWorldHopper();
            if (++this.displaySwitcherAttempts >= 3) {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Failed to quick-hop after ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(this.displaySwitcherAttempts)).append(ChatColorType.NORMAL).append(" attempts.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                this.resetQuickHopper();
            }
        } else {
            this.client.hopToWorld(this.quickHopTargetWorld);
            this.resetQuickHopper();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().equals("Please finish what you're doing before using the World Switcher.")) {
            this.resetQuickHopper();
        }
    }

    private void resetQuickHopper() {
        this.displaySwitcherAttempts = 0;
        this.quickHopTargetWorld = null;
    }

    private ChatPlayer getChatPlayerFromName(String name) {
        ClanChannelMember member;
        FriendsChatMember member2;
        String cleanName = Text.removeTags((String)name);
        FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
        if (friendsChatManager != null && (member2 = (FriendsChatMember)friendsChatManager.findByName(cleanName)) != null) {
            return member2;
        }
        ClanChannel clanChannel = this.client.getClanChannel();
        if (clanChannel != null && (member = clanChannel.findMember(cleanName)) != null) {
            return member;
        }
        clanChannel = this.client.getGuestClanChannel();
        if (clanChannel != null && (member = clanChannel.findMember(cleanName)) != null) {
            return member;
        }
        FriendContainer friendContainer = this.client.getFriendContainer();
        if (friendContainer != null) {
            return (ChatPlayer)friendContainer.findByName(cleanName);
        }
        return null;
    }

    private void pingInitialWorlds() {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null || !this.config.showSidebar() || !this.config.ping()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (net.runelite.http.api.worlds.World world : worldResult.getWorlds()) {
            int ping = this.ping(world);
            SwingUtilities.invokeLater(() -> this.panel.updatePing(world.getId(), ping));
        }
        stopwatch.stop();
        log.debug("Done pinging worlds in {}", (Object)stopwatch.elapsed());
    }

    private void pingNextWorld() {
        boolean displayPing;
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null || !this.config.showSidebar() || !this.config.ping()) {
            return;
        }
        List worlds = worldResult.getWorlds();
        if (worlds.isEmpty()) {
            return;
        }
        if (this.currentWorld >= worlds.size()) {
            this.currentWorld = 0;
        }
        net.runelite.http.api.worlds.World world = (net.runelite.http.api.worlds.World)worlds.get(this.currentWorld++);
        boolean bl = displayPing = this.config.displayPing() && this.client.getGameState() == GameState.LOGGED_IN;
        if (displayPing && this.client.getWorld() == world.getId()) {
            return;
        }
        int ping = this.ping(world);
        log.trace("Ping for world {} is: {}", (Object)world.getId(), (Object)ping);
        SwingUtilities.invokeLater(() -> this.panel.updatePing(world.getId(), ping));
    }

    private void pingCurrentWorld() {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null || !this.config.displayPing() || this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        net.runelite.http.api.worlds.World currentWorld = worldResult.findWorld(this.client.getWorld());
        if (currentWorld == null) {
            log.debug("unable to find current world: {}", (Object)this.client.getWorld());
            return;
        }
        this.currentPing = this.ping(currentWorld);
        log.trace("Ping for current world is: {}", (Object)this.currentPing);
        SwingUtilities.invokeLater(() -> this.panel.updatePing(currentWorld.getId(), this.currentPing));
    }

    Integer getStoredPing(net.runelite.http.api.worlds.World world) {
        if (!this.config.ping()) {
            return null;
        }
        return this.storedPings.get(world.getId());
    }

    private int ping(net.runelite.http.api.worlds.World world) {
        int ping = Ping.ping((net.runelite.http.api.worlds.World)world);
        this.storedPings.put(world.getId(), ping);
        return ping;
    }

    Long getTimer(int worldId) {
        return this.storedTimers.get(worldId);
    }

    private Long setTimer(int worldId) {
        long timeStamp = Instant.now().getEpochSecond() * 1000L;
        this.storedTimers.put(worldId, timeStamp);
        return timeStamp;
    }

    public int getLastWorld() {
        return this.lastWorld;
    }

    int getCurrentPing() {
        return this.currentPing;
    }
}

