/*
 * Decompiled with CFR 0.152.
 */
package com.molopl.plugins.lastseen;

import com.molopl.plugins.lastseen.LastSeenDao;
import com.molopl.plugins.lastseen.LastSeenFormatter;
import com.molopl.plugins.lastseen.LastSeenOverlay;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Friend;
import net.runelite.api.FriendContainer;
import net.runelite.api.GameState;
import net.runelite.api.Nameable;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.NameableNameChanged;
import net.runelite.api.events.RemovedFriend;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Last Seen Online", description="Track when you've last seen your friends play", tags={"last", "seen", "online", "friends", "activity", "watch"})
public class LastSeenPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LastSeenPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private LastSeenOverlay overlay;
    @Inject
    private LastSeenDao dao;
    private final Set<String> currentlyOnline = new HashSet<String>();
    private final Map<String, Long> lastSeenBuffer = new HashMap<String, Long>();

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.dao.clearCache();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.persistLastSeen();
        this.dao.clearCache();
    }

    @Subscribe
    public void onNameableNameChanged(NameableNameChanged event) {
        Nameable nameable = event.getNameable();
        if (nameable instanceof Friend && StringUtils.isNotBlank((CharSequence)nameable.getPrevName())) {
            this.dao.migrateLastSeen(Text.toJagexName((String)nameable.getPrevName()), Text.toJagexName((String)nameable.getName()));
        }
    }

    @Subscribe
    public void onRemovedFriend(RemovedFriend event) {
        this.dao.deleteLastSeen(Text.toJagexName((String)event.getNameable().getName()));
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        String displayName;
        int groupId = WidgetInfo.TO_GROUP((int)event.getActionParam1());
        this.overlay.setTooltip(null);
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() && event.getOption().equals("Message") && StringUtils.isNotBlank((CharSequence)(displayName = Text.toJagexName((String)Text.removeTags((String)event.getTarget())))) && !this.currentlyOnline.contains(displayName)) {
            Long lastSeen = this.lastSeenBuffer.getOrDefault(displayName, this.dao.getLastSeen(displayName));
            this.overlay.setTooltip("Last online: " + LastSeenFormatter.format(lastSeen));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        FriendContainer friendContainer;
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.client.getTickCount() % 100 == 0) {
            this.persistLastSeen();
        }
        if ((friendContainer = this.client.getFriendContainer()) == null) {
            return;
        }
        this.currentlyOnline.clear();
        Arrays.stream((Friend[])friendContainer.getMembers()).filter(friend -> friend.getWorld() > 0).forEach(friend -> this.currentlyOnline.add(Text.toJagexName((String)friend.getName())));
        long currentTimeMillis = System.currentTimeMillis();
        this.currentlyOnline.forEach(displayName -> this.lastSeenBuffer.put((String)displayName, currentTimeMillis));
    }

    private void persistLastSeen() {
        this.lastSeenBuffer.forEach(this.dao::setLastSeen);
        this.lastSeenBuffer.clear();
    }
}

