/*
 * Decompiled with CFR 0.152.
 */
package com.molopl.plugins.lastseen;

import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public class LastSeenFormatter {
    public static String format(@Nullable Long lastSeenMillis) {
        if (lastSeenMillis == null) {
            return "never";
        }
        long diffMillis = System.currentTimeMillis() - lastSeenMillis;
        return Arrays.stream(TimeUnit.values()).map(timeUnit -> LastSeenFormatter.formatIfInUnit(diffMillis, timeUnit)).filter(Objects::nonNull).findFirst().orElse("just now");
    }

    @Nullable
    private static String formatIfInUnit(long diffMillis, TimeUnit timeUnit) {
        long durationInUnit = diffMillis / timeUnit.getTemporalUnit().getDuration().toMillis();
        return durationInUnit > 0L ? String.format("%d %s ago", durationInUnit, durationInUnit == 1L ? timeUnit.getSingularForm() : timeUnit.getPluralForm()) : null;
    }

    private static enum TimeUnit {
        DAYS(ChronoUnit.DAYS, "day", "days"),
        HOURS(ChronoUnit.HOURS, "hour", "hours"),
        MINUTES(ChronoUnit.MINUTES, "minute", "minutes");

        private final TemporalUnit temporalUnit;
        private final String singularForm;
        private final String pluralForm;

        public TemporalUnit getTemporalUnit() {
            return this.temporalUnit;
        }

        public String getSingularForm() {
            return this.singularForm;
        }

        public String getPluralForm() {
            return this.pluralForm;
        }

        private TimeUnit(TemporalUnit temporalUnit, String singularForm, String pluralForm) {
            this.temporalUnit = temporalUnit;
            this.singularForm = singularForm;
            this.pluralForm = pluralForm;
        }
    }
}

