/*
 * Decompiled with CFR 0.152.
 */
package com.molopl.plugins.lastseen;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastSeenDao {
    private static final Logger log = LoggerFactory.getLogger(LastSeenDao.class);
    public static final String CONFIG_GROUP = "lastSeenOnline";
    public static final String KEY_PREFIX = "lastSeen_";
    private final ConfigManager configManager;
    private final Map<String, Long> cache = new HashMap<String, Long>();

    @Inject
    public LastSeenDao(ConfigManager configManager) {
        this.configManager = configManager;
    }

    @Nullable
    public Long getLastSeen(String displayName) {
        if (this.cache.containsKey(displayName)) {
            return this.cache.get(displayName);
        }
        log.debug("Fetching 'last seen' for player {}", (Object)displayName);
        String entry = this.configManager.getConfiguration(CONFIG_GROUP, KEY_PREFIX + displayName);
        if (entry != null) {
            try {
                long timestampMillis = Long.parseLong(entry);
                this.cache.put(displayName, timestampMillis);
                return timestampMillis;
            }
            catch (NumberFormatException e) {
                log.info("Invalid value stored as 'last seen' for player {}: {}", (Object)displayName, (Object)entry);
            }
        }
        this.cache.put(displayName, null);
        return null;
    }

    public void setLastSeen(String displayName, long timestampMillis) {
        Long lastSeen = this.getLastSeen(displayName);
        if (lastSeen == null || lastSeen < timestampMillis) {
            this.cache.put(displayName, timestampMillis);
            this.configManager.setConfiguration(CONFIG_GROUP, KEY_PREFIX + displayName, Long.toString(timestampMillis));
        }
    }

    public void deleteLastSeen(String displayName) {
        this.cache.remove(displayName);
        this.configManager.unsetConfiguration(CONFIG_GROUP, KEY_PREFIX + displayName);
    }

    public void migrateLastSeen(String oldDisplayName, String newDisplayName) {
        log.debug("Migrating 'last seen' after player rename from {} to {}", (Object)oldDisplayName, (Object)newDisplayName);
        Long lastSeen = this.getLastSeen(oldDisplayName);
        if (lastSeen != null) {
            this.setLastSeen(newDisplayName, lastSeen);
            this.deleteLastSeen(oldDisplayName);
        }
    }

    public void clearCache() {
        this.cache.clear();
    }
}

