/*
 * Decompiled with CFR 0.152.
 */
package com.whosgonnapoop.ui;

import com.whosgonnapoop.WhosGonnaPoop;
import com.whosgonnapoop.WhosGonnaPoopConfig;
import com.whosgonnapoop.ui.ResetButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhosGonnaPoopPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(WhosGonnaPoopPanel.class);
    private final WhosGonnaPoop plugin;
    private final WhosGonnaPoopConfig config;
    private final JPanel contentPanel;
    private ResetButton onePooper;
    private ResetButton twoPooper;
    private ResetButton advanceButton;

    private JTextArea createTextArea(String text) {
        JTextArea textArea = new JTextArea(5, 22);
        textArea.setText(text);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setFocusable(false);
        textArea.setOpaque(false);
        return textArea;
    }

    @Inject
    public WhosGonnaPoopPanel(WhosGonnaPoop plugin, WhosGonnaPoopConfig config) {
        super(false);
        this.plugin = plugin;
        this.config = config;
        JLabel title = new JLabel("Who's Gonna Poop?");
        title.setBorder(new EmptyBorder(0, 0, 6, 0));
        title.setForeground(Color.WHITE);
        title.setHorizontalAlignment(0);
        this.contentPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.add(title, "North");
        this.create1Button();
        this.create2Button();
        this.createAdvanceButton();
        this.add(this.contentPanel, "Center");
    }

    private void create1Button() {
        this.onePooper = new ResetButton("1 Pooper");
        this.onePooper.setPreferredSize(new Dimension(225, 30));
        this.onePooper.addMouseButton1PressedHandler(() -> {
            this.plugin.howManyPoopers = 1;
            this.plugin.resetPoopers();
        });
        this.contentPanel.add(this.onePooper);
    }

    private void create2Button() {
        this.twoPooper = new ResetButton("2 Poopers");
        this.twoPooper.setPreferredSize(new Dimension(225, 30));
        this.twoPooper.addMouseButton2PressedHandler(() -> {
            this.plugin.howManyPoopers = 2;
            this.plugin.resetPoopers();
        });
        this.contentPanel.add(this.twoPooper);
    }

    private void createAdvanceButton() {
        this.advanceButton = new ResetButton("Advance Orbs (Hotkey: " + this.config.nextPhaseHotkey().toString() + ")");
        this.advanceButton.setPreferredSize(new Dimension(225, 30));
        this.advanceButton.addAdvanceButtonHandler(() -> this.plugin.triggerPoopSwap());
        this.contentPanel.add(this.advanceButton);
    }

    public void updateAdvanceButton() {
        this.advanceButton.setText("Advance Orbs (Hotkey: " + this.config.nextPhaseHotkey().toString() + ")");
    }
}

