/*
 * Decompiled with CFR 0.152.
 */
package com.whosgonnapoop;

import com.google.inject.Provides;
import com.whosgonnapoop.PlayerWidgetIndex;
import com.whosgonnapoop.WhosGonnaPoopConfig;
import com.whosgonnapoop.ui.WhosGonnaPoopPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetClosed;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Whos Gonna Poop?", description="A plugin to keep track of who has pooped and should poop next in Kephri", tags={"poop", "kephri", "toa", "tombs", "amascut", "hotkey"})
public class WhosGonnaPoop
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WhosGonnaPoop.class);
    public ArrayList<PlayerWidgetIndex> playerArrayList;
    public ArrayList<Integer> currentPoopIndexes;
    public ArrayList<Integer> invalidOrbIndexes;
    @Inject
    private Client client;
    @Inject
    private WhosGonnaPoopConfig config;
    @Inject
    private KeyManager keyManager;
    @Inject
    private WhosGonnaPoopPanel panel;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navigationButton;
    final int TOA_PARTY_1 = 31522822;
    final int TOA_PARTY_2 = 31522826;
    final int TOA_PARTY_3 = 0x1E1000E;
    final int TOA_PARTY_4 = 31522834;
    final int TOA_PARTY_5 = 31522838;
    final int TOA_PARTY_6 = 31522842;
    final int TOA_PARTY_7 = 0x1E1001E;
    final int TOA_PARTY_8 = 31522850;
    final int TOA_MIDDLE_ROOM = 14160;
    final int TOA_PUZZLE_ROOM = 14162;
    final int TOA_KEPHRI_ROOM = 14164;
    final int TOA_LOBBY_ROOM = 13454;
    final int KEPHRI_ID = 11719;
    public int howManyPoopers;
    private HotkeyListener hotkey;

    @Provides
    WhosGonnaPoopConfig provideConfig(ConfigManager configManager) {
        return (WhosGonnaPoopConfig)configManager.getConfig(WhosGonnaPoopConfig.class);
    }

    public void startUp() {
        this.hotkey = new HotkeyListener(() -> this.config.nextPhaseHotkey()){

            public void hotkeyPressed() {
                WhosGonnaPoop.this.triggerPoopSwap();
            }
        };
        this.currentPoopIndexes = new ArrayList();
        this.playerArrayList = new ArrayList();
        this.invalidOrbIndexes = new ArrayList();
        this.howManyPoopers = 1;
        this.panel = new WhosGonnaPoopPanel(this, this.config);
        this.navigationButton = NavigationButton.builder().tooltip("Who's Gonna Poop?").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/poop.png")).priority(1002).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    public void triggerPoopSwap() {
        int min = Collections.min(this.currentPoopIndexes);
        int max = Collections.max(this.currentPoopIndexes);
        if (this.playerArrayList.size() == this.howManyPoopers) {
            return;
        }
        this.updatePoopIndexes(min, max);
    }

    public void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkey);
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.playerArrayList.clear();
        this.currentPoopIndexes.clear();
    }

    @Subscribe(priority=100.0f)
    private void onClientShutdown(ClientShutdown e) {
    }

    public ArrayList<String> currentNames() {
        return this.playerArrayList.stream().filter(x -> this.currentPoopIndexes.contains(x.index)).findFirst().isPresent() ? this.playerArrayList.stream().filter(x -> this.currentPoopIndexes.contains(x.index)).collect(Collectors.toCollection(ArrayList::new)).stream().map(PlayerWidgetIndex::getName).collect(Collectors.toCollection(ArrayList::new)) : new ArrayList();
    }

    public int getWidgetBaseID(int index) {
        switch (index) {
            case 0: {
                return 31522822;
            }
            case 1: {
                return 31522826;
            }
            case 2: {
                return 0x1E1000E;
            }
            case 3: {
                return 31522834;
            }
            case 4: {
                return 31522838;
            }
            case 5: {
                return 31522842;
            }
            case 6: {
                return 0x1E1001E;
            }
            case 7: {
                return 31522850;
            }
        }
        return 31522822;
    }

    public int getNextAvailableOrbIndexFrom(int startingIndex) {
        int validCount = 0;
        int index = startingIndex + 1 > this.playerArrayList.size() - 1 ? 0 : startingIndex + 1;
        PlayerWidgetIndex pwi = null;
        while (validCount < 1) {
            if (!this.invalidOrbIndexes.contains(this.playerArrayList.get((int)index).index)) {
                ++validCount;
            }
            if (validCount == 1) {
                pwi = this.playerArrayList.get(index);
            }
            if (index == this.playerArrayList.size() - 1) {
                index = 0;
                continue;
            }
            ++index;
        }
        return pwi.index;
    }

    public PlayerWidgetIndex traverseOrbs(int startingOrb) {
        int validCount = 0;
        int index = startingOrb + 1 > this.playerArrayList.size() - 1 ? 0 : startingOrb + 1;
        PlayerWidgetIndex pwi = null;
        while (validCount < this.howManyPoopers) {
            if (!this.invalidOrbIndexes.contains(this.playerArrayList.get((int)index).index)) {
                ++validCount;
            }
            if (validCount == this.howManyPoopers) {
                pwi = this.playerArrayList.get(index);
            }
            if (index == this.playerArrayList.size() - 1) {
                index = 0;
                continue;
            }
            ++index;
        }
        return pwi;
    }

    public void updatePoopIndexes(int min, int max) {
        this.currentPoopIndexes.clear();
        PlayerWidgetIndex maxPWI = null;
        PlayerWidgetIndex minPWI = null;
        if (this.playerArrayList.size() == 1) {
            return;
        }
        maxPWI = this.traverseOrbs(max);
        minPWI = this.traverseOrbs(min);
        if (minPWI != null && this.howManyPoopers == 2) {
            this.currentPoopIndexes.add(minPWI.index);
        }
        if (maxPWI != null) {
            this.currentPoopIndexes.add(maxPWI.index);
        }
    }

    public void resetPoopers() {
        if (this.playerArrayList.size() == 0) {
            return;
        }
        if (this.howManyPoopers == 2 && this.playerArrayList.size() == 1) {
            this.howManyPoopers = 1;
            return;
        }
        if (this.howManyPoopers > this.currentPoopIndexes.size()) {
            if (this.currentPoopIndexes.get(0) == this.playerArrayList.size() - 1) {
                this.currentPoopIndexes.add(this.getNextAvailableOrbIndexFrom(0));
            } else {
                this.currentPoopIndexes.add(this.getNextAvailableOrbIndexFrom(this.currentPoopIndexes.get(0)));
            }
        } else if (this.howManyPoopers < this.currentPoopIndexes.size()) {
            this.currentPoopIndexes.remove(this.currentPoopIndexes.size() - 1);
        }
    }

    public void highlightPooperOrbs() {
        if (this.client.getWidget(31522822) == null) {
            return;
        }
        for (PlayerWidgetIndex pwi : this.playerArrayList) {
            if (this.currentPoopIndexes.contains(pwi.index)) {
                this.client.getWidget(pwi.widgetID + 1).setSpriteId(1990);
                this.client.getWidget(pwi.widgetID + 2).setHidden(true);
                this.client.getWidget(pwi.widgetID + 3).setHidden(true);
                continue;
            }
            this.client.getWidget(pwi.widgetID + 1).setSpriteId(1697);
            this.client.getWidget(pwi.widgetID + 2).setHidden(false);
            this.client.getWidget(pwi.widgetID + 3).setHidden(false);
        }
    }

    public boolean isinKephri(Player player) {
        if (player == null) {
            return false;
        }
        int regionId = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player.getLocalLocation()).getRegionID();
        return regionId == 14164;
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed e) {
        if (e.getGroupId() == 772) {
            if (this.playerArrayList != null) {
                this.playerArrayList.clear();
            }
            if (this.currentPoopIndexes != null) {
                this.currentPoopIndexes.clear();
            }
            if (this.invalidOrbIndexes != null) {
                this.invalidOrbIndexes.clear();
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        this.panel.updateAdvanceButton();
    }

    public void syncUsers() {
        if (this.client.getVarcStrValue(1099) == "" || !this.isinKephri(this.client.getLocalPlayer()) || this.client.getPlayers().size() == this.playerArrayList.size() || this.client.getPlayers().size() == 0) {
            return;
        }
        if (this.client.getNpcs().stream().filter(x -> x.getId() == 11719).findFirst().isPresent() && this.client.getNpcs().stream().filter(x -> x.getId() == 11719).findFirst().get().getHealthRatio() == -1 && this.playerArrayList.size() <= this.client.getPlayers().size()) {
            this.resetValues();
            this.regenerateViaOrbs();
        } else if (this.playerArrayList.size() > this.client.getPlayers().size()) {
            this.playerArrayList.clear();
            log.info("Regenerating player orbs, there are less players in the boss than we have in our list");
            for (int i = 1099; i < 1099 + this.client.getPlayers().size(); ++i) {
                this.playerArrayList.add(new PlayerWidgetIndex(this.client.getVarcStrValue(i).replace('\u00a0', ' '), this.playerArrayList.size(), this.getWidgetBaseID(this.playerArrayList.size())));
                log.info(this.client.getVarcStrValue(i).replace('\u00a0', ' '));
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() != 14164 && WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() != 14162 && WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() != 14160 && WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() != 13454) {
            this.keyManager.unregisterKeyListener((KeyListener)this.hotkey);
            return;
        }
        if (this.isinKephri(this.client.getLocalPlayer())) {
            this.keyManager.registerKeyListener((KeyListener)this.hotkey);
            this.syncUsers();
            this.highlightPooperOrbs();
        }
        if (WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() == 14160 && this.playerArrayList.size() < this.client.getPlayers().size() && this.client.getWidget(31522822) != null) {
            this.playerArrayList.clear();
            for (int i = 1099; i < 1099 + this.client.getPlayers().size(); ++i) {
                this.playerArrayList.add(new PlayerWidgetIndex(this.client.getVarcStrValue(i).replace('\u00a0', ' '), this.playerArrayList.size(), this.getWidgetBaseID(this.playerArrayList.size())));
                log.info(this.client.getVarcStrValue(i).replace('\u00a0', ' '));
                if (this.currentPoopIndexes.size() >= this.howManyPoopers) continue;
                this.currentPoopIndexes.add(this.playerArrayList.size() - 1);
            }
        }
    }

    public void regenerateViaOrbs() {
        for (int i = 1099; i < 1099 + this.client.getPlayers().size(); ++i) {
            this.playerArrayList.add(new PlayerWidgetIndex(this.client.getVarcStrValue(i).replace('\u00a0', ' '), this.playerArrayList.size(), this.getWidgetBaseID(this.playerArrayList.size())));
            log.info(this.client.getVarcStrValue(i).replace('\u00a0', ' '));
            if (this.currentPoopIndexes.size() >= this.howManyPoopers) continue;
            this.currentPoopIndexes.add(this.playerArrayList.size() - 1);
        }
    }

    public void resetValues() {
        this.playerArrayList.clear();
        this.currentPoopIndexes.clear();
    }

    @Subscribe
    public void onActorDeath(ActorDeath e) {
        if (e.getActor() instanceof Player && this.isinKephri((Player)e.getActor())) {
            PlayerWidgetIndex temp = this.playerArrayList.stream().filter(x -> x.name.equals(e.getActor().getName())).findFirst().get();
            this.invalidOrbIndexes.add(temp.index);
            if (this.currentPoopIndexes.contains(temp.index)) {
                this.currentPoopIndexes.removeIf(x -> x == temp.index);
                if (this.invalidOrbIndexes.size() < this.playerArrayList.size()) {
                    this.currentPoopIndexes.add(this.getNextAvailableOrbIndexFrom(temp.index));
                }
            }
            if (this.invalidOrbIndexes.size() == this.playerArrayList.size()) {
                this.invalidOrbIndexes.clear();
                this.resetValues();
                this.regenerateViaOrbs();
            }
        }
    }

    public ArrayList<PlayerWidgetIndex> getPlayerArrayList() {
        return this.playerArrayList;
    }

    public ArrayList<Integer> getCurrentPoopIndexes() {
        return this.currentPoopIndexes;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public int getHowManyPoopers() {
        return this.howManyPoopers;
    }
}

