/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import com.google.inject.Provides;
import com.skeldoor.AmazeingChestConfig;
import com.skeldoor.AmazeingChestOverlay;
import com.skeldoor.MazeChest;
import java.awt.Color;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Amazeing Chest", description="Shows how long until a maze random chest closes")
public class AmazeingChestPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AmazeingChestPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AmazeingChestOverlay overlay;
    @Inject
    private AmazeingChestConfig config;
    @Inject
    private Notifier notifier;
    private final int openedChestId = 14988;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        if (gameObjectSpawned.getGameObject().getId() == 14988) {
            MazeChest mazeChest = new MazeChest(gameObjectSpawned.getGameObject(), gameObjectSpawned.getGameObject().getWorldLocation(), Instant.now());
            this.overlay.addMazeChest(mazeChest);
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned gameObjectDespawned) {
        if (gameObjectDespawned.getGameObject().getId() == 14988) {
            this.overlay.removeMazeChest(gameObjectDespawned.getGameObject().getWorldLocation());
            if (this.config.sendNotification()) {
                this.notifier.notify("Maze random chest closed");
            }
        }
    }

    public Color overlayColour() {
        return this.config.overlayColour();
    }

    @Provides
    AmazeingChestConfig provideConfig(ConfigManager configManager) {
        return (AmazeingChestConfig)configManager.getConfig(AmazeingChestConfig.class);
    }
}

