/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import com.skeldoor.AmazeingChestPlugin;
import com.skeldoor.MazeChest;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class AmazeingChestOverlay
extends Overlay {
    private final Client client;
    private final AmazeingChestPlugin plugin;
    private static final Font FONT = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
    private static final int MAX_DISTANCE = 2400;
    private List<MazeChest> mazeChests = new ArrayList<MazeChest>();

    @Inject
    private AmazeingChestOverlay(Client client, AmazeingChestPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGHEST);
        this.client = client;
        this.plugin = plugin;
    }

    public void addMazeChest(MazeChest mazeChest) {
        this.mazeChests.add(mazeChest);
    }

    public void removeMazeChest(WorldPoint loc) {
        this.mazeChests.removeIf(mazeChest -> mazeChest.getLocation().equals((Object)loc));
    }

    public Dimension render(Graphics2D graphics) {
        graphics.setFont(FONT);
        graphics.setColor(this.plugin.overlayColour());
        for (MazeChest mazeChest : this.mazeChests) {
            this.renderGameObjects(graphics, mazeChest, this.client);
        }
        return null;
    }

    private void renderGameObjects(Graphics2D graphics, MazeChest mazeChest, Client client) {
        if (mazeChest != null && mazeChest.getLocation() != null) {
            Player player = client.getLocalPlayer();
            LocalPoint mazeChestLocal = LocalPoint.fromWorld((Client)client, (WorldPoint)mazeChest.getLocation());
            if (mazeChestLocal != null && player.getLocalLocation().distanceTo(mazeChestLocal) <= 2400) {
                StringBuilder stringBuilder = new StringBuilder();
                long despawnTimeMillis = mazeChest.getDespawnTime().toEpochMilli() - Instant.now().toEpochMilli();
                String timerText = String.format("%.0fs", Float.valueOf((float)despawnTimeMillis / 1000.0f));
                stringBuilder.append("Closing in ").append(timerText);
                OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)mazeChest.getGameObject(), (String)stringBuilder.toString(), (Color)this.plugin.overlayColour());
            }
        }
    }
}

