/*
 * Decompiled with CFR 0.152.
 */
package com.zeroremover;

import com.google.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Zero Remover", description="Removes the redundant 0 from precise timers.", tags={"zero", "timer", "remove", "0"})
public class ZeroRemoverPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ZeroRemoverPlugin.class);
    @Inject
    private Client client;
    private boolean ShouldReplace = false;
    private boolean ReplaceNow = false;

    protected void startUp() {
        this.ShouldReplace = true;
    }

    protected void shutDown() {
        this.ShouldReplace = false;
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        this.ReplaceNow = true;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.ShouldReplace && this.ReplaceNow) {
            if (this.client.isResized()) {
                this.ReplaceWText(new Widget[]{this.client.getWidget(10551316)});
                this.ReplaceWText(new Widget[]{this.client.getWidget(10747924)});
            } else {
                this.ReplaceWText(new Widget[]{this.client.getWidget(35913756)});
            }
            this.ReplaceNow = false;
        }
    }

    private void ReplaceWText(Widget[] parent) {
        if (parent == null) {
            return;
        }
        for (Widget w : parent) {
            if (w == null) continue;
            String message = w.getText();
            if (message != null) {
                String replacement = message.replaceAll("([0-9]*?:*)([0-9]{1,2})\\.([0-9])0", "$1$2.$3");
                w.setText(replacement);
            }
            this.ReplaceWText(w.getNestedChildren());
            this.ReplaceWText(w.getStaticChildren());
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (!this.ShouldReplace) {
            return;
        }
        ChatMessageType chatMessageType = chatMessage.getType();
        if (chatMessageType == ChatMessageType.GAMEMESSAGE || chatMessageType == ChatMessageType.FRIENDSCHATNOTIFICATION) {
            MessageNode messageNode = chatMessage.getMessageNode();
            String message = messageNode.getValue();
            String replacement = message.replaceAll("([0-9]*?:*)([0-9]{1,2})\\.([0-9])0", "$1$2.$3");
            messageNode.setValue(replacement);
        }
    }
}

