/*
 * Decompiled with CFR 0.152.
 */
package com.tickdanceaim;

import com.google.inject.Provides;
import com.tickdanceaim.ItemSwitch;
import com.tickdanceaim.TickDanceAimConfig;
import com.tickdanceaim.TickDanceAimOverlay;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Tick dance")
public class TickDanceAimPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TickDanceAimPlugin.class);
    @Inject
    private TickDanceAimConfig config;
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private TickDanceAimOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    ArrayList<ItemSwitch> itemSwitches;
    ArrayList<Integer> switchPattern;
    int activeSwitch = 0;
    int switchTick = 0;
    @Inject
    ItemManager itemManager;
    public WorldPoint gameAreaCorner1;
    public WorldPoint gameAreaCorner2;
    public WorldArea gameArea = null;
    public WorldPoint tile1 = new WorldPoint(0, 0, 0);
    public WorldPoint tile2 = new WorldPoint(0, 0, 0);
    private int successfulTicks = 0;
    private int successfulSwitches = 0;
    private int successfulTiles = 0;
    public int tickCounter = 0;
    private int ticksInteracted = 0;
    private int tickGameUpdated = 0;
    private Random rnd;

    @Provides
    TickDanceAimConfig provideConfig(ConfigManager cm) {
        return (TickDanceAimConfig)cm.getConfig(TickDanceAimConfig.class);
    }

    protected void startUp() {
        int i;
        this.overlayManager.add((Overlay)this.overlay);
        this.rnd = new Random();
        this.itemSwitches = new ArrayList();
        this.switchPattern = new ArrayList();
        for (i = 0; i < 5; ++i) {
            this.itemSwitches.add(new ItemSwitch());
        }
        this.itemSwitches.get(0).fromString(this.config.switchIds1());
        this.itemSwitches.get(1).fromString(this.config.switchIds2());
        this.itemSwitches.get(2).fromString(this.config.switchIds3());
        this.itemSwitches.get(3).fromString(this.config.switchIds4());
        this.itemSwitches.get(4).fromString(this.config.switchIds5());
        for (i = 0; i < 5; ++i) {
            this.itemSwitches.get(i).updateImage(this.itemManager);
        }
        this.parseSwitchConfig();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    private void onGameTick(GameTick gameTick) {
        ++this.tickCounter;
        if (this.gameArea == null) {
            return;
        }
        if (this.client.getLocalPlayer().getWorldLocation().distanceTo(this.gameArea) > 15) {
            return;
        }
        boolean updateRequired = false;
        boolean streakFailed = false;
        if (this.tickGameUpdated + this.config.updateRate() <= this.tickCounter) {
            if (this.client.getLocalPlayer().getInteracting() == null) {
                this.ticksInteracted = 0;
                updateRequired = true;
            } else {
                ++this.ticksInteracted;
                if (this.ticksInteracted > this.config.interactionPause()) {
                    updateRequired = true;
                }
            }
        }
        if (this.tile1 != null && this.tile2 != null && updateRequired && !this.tile1.equals((Object)this.client.getLocalPlayer().getWorldLocation())) {
            streakFailed = true;
        } else if (updateRequired) {
            ++this.successfulTiles;
        }
        int prevSwitch = this.activeSwitch;
        this.updateActiveSwitch();
        if (prevSwitch != this.activeSwitch) {
            if (!this.itemSwitches.get(prevSwitch).isWearing(this.client)) {
                streakFailed = true;
            } else {
                this.successfulSwitches += this.itemSwitches.get((int)prevSwitch).items.size();
            }
        }
        if (streakFailed) {
            if (this.successfulTicks > this.config.updateRate() + 1 && this.config.printStreaks()) {
                this.printStreak();
            }
            this.successfulTicks = 0;
            this.successfulTiles = 0;
            this.successfulSwitches = 0;
        } else {
            ++this.successfulTicks;
        }
        if (updateRequired) {
            this.updateTiles();
        }
    }

    private void printStreak() {
        if (this.successfulTicks <= 0) {
            return;
        }
        float tilesAvg = (float)this.successfulTiles / (float)(this.successfulTicks + 1);
        float switchesAvg = (float)this.successfulSwitches / (float)(this.successfulTicks + 1);
        String msg = "Tick Dance: Ticks " + this.successfulTicks + "     tiles/tick " + String.format("%.2f", Float.valueOf(tilesAvg)) + "     ";
        if (this.successfulSwitches > 0) {
            msg = msg + "switches/tick " + String.format("%.2f", Float.valueOf(switchesAvg)) + "     ";
        }
        msg = msg + this.gameArea.getWidth() + "x" + this.gameArea.getHeight();
        this.client.addChatMessage(ChatMessageType.TRADE, "", msg, null);
    }

    private void updateTiles() {
        this.tickGameUpdated = this.tickCounter;
        if (this.gameAreaCorner1 == null || this.gameArea == null) {
            return;
        }
        WorldPoint n = this.genNextTile();
        if (n == null) {
            return;
        }
        this.tile1 = this.tile2;
        this.tile2 = n;
    }

    private void updateActiveSwitch() {
        if (!this.switchPattern.isEmpty()) {
            this.activeSwitch = this.switchPattern.get(this.tickCounter % this.switchPattern.size());
            return;
        }
        if (this.switchTick + this.config.switchRate() <= this.tickCounter) {
            this.switchTick = this.tickCounter;
            ArrayList<Integer> nonEmpty = new ArrayList<Integer>();
            for (int i = 0; i < this.itemSwitches.size(); ++i) {
                if (this.itemSwitches.get(i).isEmpty() || !this.config.repeatingSwitches() && i == this.activeSwitch) continue;
                nonEmpty.add(i);
            }
            if (nonEmpty.isEmpty()) {
                return;
            }
            this.activeSwitch = (Integer)nonEmpty.get(this.rnd.nextInt(nonEmpty.size()));
        }
    }

    private WorldPoint genNextTile() {
        ArrayList<WorldPoint> cand;
        if (this.gameArea == null) {
            return null;
        }
        if (this.tile1 == null || !this.tile1.isInArea(new WorldArea[]{this.gameArea})) {
            this.tile1 = this.gameArea.toWorldPoint();
        }
        if (this.tile2 == null || !this.tile2.isInArea(new WorldArea[]{this.gameArea})) {
            this.tile2 = this.gameArea.toWorldPoint();
        }
        if ((cand = this.genTileCandidates(this.tile2)).size() > 0) {
            return cand.get(Math.abs(this.rnd.nextInt() % cand.size()));
        }
        return null;
    }

    private ArrayList<WorldPoint> genTileCandidates(WorldPoint center) {
        ArrayList<WorldPoint> ret = new ArrayList<WorldPoint>();
        WorldPoint pPos = center;
        WorldPoint pStart = pPos.dx(-2).dy(-2);
        WorldArea pArea = new WorldArea(pStart.getX(), pStart.getY(), 5, 5, pStart.getPlane());
        List pAreaPoints = pArea.toWorldPointList();
        for (WorldPoint p : pAreaPoints) {
            int diffx = pPos.getX() - p.getX();
            int diffy = pPos.getY() - p.getY();
            if (this.gameArea.distanceTo(p) != 0 || pPos.equals((Object)p) || p.equals((Object)this.tile1) || p.equals((Object)this.tile2) || !this.config.walkTiles() && pPos.distanceTo(p) < 2 || !this.config.runTiles() && pPos.distanceTo(p) > 1 || !this.config.cardinalTiles() && (diffx == 0 || diffy == 0) || !this.config.diagonalTiles() && Math.abs(diffx) == Math.abs(diffy) || !this.config.LTiles() && (Math.abs(diffx) == 2 && Math.abs(diffy) == 1 || Math.abs(diffy) == 2 && Math.abs(diffx) == 1)) continue;
            ret.add(p);
        }
        return ret;
    }

    private int randomRange(int start, int end) {
        if (start == end) {
            return start;
        }
        return Math.min(start, end) + this.rnd.nextInt(Math.abs(end - start) + 1);
    }

    private WorldPoint worldPointRandom(WorldPoint start, WorldPoint end) {
        return new WorldPoint(this.randomRange(start.getX(), end.getX()), this.randomRange(start.getY(), end.getY()), this.randomRange(start.getPlane(), end.getPlane()));
    }

    private void setArea(WorldPoint p1, WorldPoint p2) {
        if (p1 != null && p2 != null) {
            WorldPoint sw = new WorldPoint(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), p1.getPlane());
            int width = Math.abs(p1.getX() - p2.getX()) + 1;
            int height = Math.abs(p1.getY() - p2.getY()) + 1;
            this.gameArea = new WorldArea(sw, width, height);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        Widget w;
        boolean hotKeyPressed = this.client.isKeyPressed(81);
        if (!hotKeyPressed) {
            return;
        }
        if (event.getOption().equals("Walk here")) {
            Tile selectedSceneTile = this.client.getSelectedSceneTile();
            if (selectedSceneTile == null) {
                return;
            }
            MenuEntry subMenu = this.client.createMenuEntry(-1).setOption("Tick Dance").setType(MenuAction.RUNELITE_SUBMENU);
            this.client.createMenuEntry(-1).setOption("Set corner 1").setType(MenuAction.RUNELITE).setParent(subMenu).onClick(e -> {
                Tile target = this.client.getSelectedSceneTile();
                if (target != null) {
                    this.gameAreaCorner1 = target.getWorldLocation();
                    this.setArea(this.gameAreaCorner1, this.gameAreaCorner2);
                    this.tickGameUpdated = 0;
                }
            });
            this.client.createMenuEntry(-2).setOption("Set corner 2").setType(MenuAction.RUNELITE).setParent(subMenu).onClick(e -> {
                Tile target = this.client.getSelectedSceneTile();
                if (target != null) {
                    this.gameAreaCorner2 = target.getWorldLocation();
                    this.setArea(this.gameAreaCorner1, this.gameAreaCorner2);
                    this.tickGameUpdated = 0;
                }
            });
        }
        if ((w = event.getMenuEntry().getWidget()) != null && WidgetInfo.TO_GROUP((int)w.getId()) == 149 && "Examine".equals(event.getOption()) && event.getIdentifier() == 10) {
            this.createSwitchMenuEntries(event);
        }
    }

    public void createSwitchMenuEntries(MenuEntryAdded event) {
        Widget w = event.getMenuEntry().getWidget();
        int itemId = w.getItemId();
        MenuEntry subMenu = this.client.createMenuEntry(-1).setOption("Tick Dance").setTarget(event.getTarget()).setType(MenuAction.RUNELITE_SUBMENU);
        for (int i = 0; i < this.itemSwitches.size(); ++i) {
            int ii = i;
            if (!this.itemSwitches.get((int)ii).items.contains(itemId)) {
                this.client.createMenuEntry(-ii - 1).setOption("Add to switch " + (ii + 1)).setType(MenuAction.RUNELITE).setParent(subMenu).onClick(e -> {
                    this.itemSwitches.get((int)ii).items.add(itemId);
                    this.updateSwitchConfigText(ii);
                    this.itemSwitches.get(ii).updateImage(this.itemManager);
                });
                continue;
            }
            this.client.createMenuEntry(-ii - 1).setOption("Remove from switch " + (ii + 1)).setType(MenuAction.RUNELITE).setParent(subMenu).onClick(e -> {
                this.itemSwitches.get((int)ii).items.remove((Object)itemId);
                this.updateSwitchConfigText(ii);
                this.itemSwitches.get(ii).updateImage(this.itemManager);
            });
        }
    }

    private void updateSwitchConfigText(int i) {
        switch (i) {
            case 0: {
                this.config.setSwitchIds1(this.itemSwitches.get(i).toString());
                break;
            }
            case 1: {
                this.config.setSwitchIds2(this.itemSwitches.get(i).toString());
                break;
            }
            case 2: {
                this.config.setSwitchIds3(this.itemSwitches.get(i).toString());
                break;
            }
            case 3: {
                this.config.setSwitchIds4(this.itemSwitches.get(i).toString());
                break;
            }
            case 4: {
                this.config.setSwitchIds5(this.itemSwitches.get(i).toString());
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("TickDanceAimConfig")) {
            if (event.getKey().equals("switchPattern")) {
                this.parseSwitchConfig();
            } else {
                Integer id = null;
                if (event.getKey().equals("switchIds1")) {
                    id = 0;
                } else if (event.getKey().equals("switchIds2")) {
                    id = 1;
                } else if (event.getKey().equals("switchIds3")) {
                    id = 2;
                } else if (event.getKey().equals("switchIds4")) {
                    id = 3;
                } else if (event.getKey().equals("switchIds5")) {
                    id = 4;
                }
                if (id == null) {
                    return;
                }
                this.itemSwitches.get(id).fromString(event.getNewValue());
                this.itemSwitches.get(id).updateImage(this.itemManager);
            }
        }
    }

    private void parseSwitchConfig() {
        this.switchPattern.clear();
        String ss = this.config.switchPattern();
        for (String s : ss.split(",")) {
            try {
                Integer sw = Integer.parseInt(s.trim());
                if (sw < 1 || sw > 5) continue;
                this.switchPattern.add(sw - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public int patternTicksRemaining() {
        int count = 0;
        int n = this.tickCounter % this.switchPattern.size();
        int prevVal = this.switchPattern.get(n);
        for (int i = n; i < this.switchPattern.size(); ++i) {
            int val = this.switchPattern.get(i);
            if (val == prevVal) {
                ++count;
            } else {
                return count;
            }
            prevVal = val;
        }
        return count;
    }
}

