/*
 * Decompiled with CFR 0.152.
 */
package com.tickdanceaim;

import com.tickdanceaim.ItemSwitch;
import com.tickdanceaim.TickDanceAimConfig;
import com.tickdanceaim.TickDanceAimPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
class TickDanceAimOverlay
extends Overlay {
    private final TickDanceAimConfig config;
    private final Client client;
    private final TickDanceAimPlugin plugin;
    private static final int MAX_DRAW_DISTANCE = 32;
    private static final int LOCAL_TILE_SIZE = 128;

    @Inject
    private TickDanceAimOverlay(Client client, TickDanceAimConfig config, TickDanceAimPlugin plugin) {
        this.config = config;
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.gameArea == null) {
            return null;
        }
        if (this.plugin.gameArea.distanceTo(this.client.getLocalPlayer().getWorldLocation()) > 32) {
            return null;
        }
        if (this.config.tile1Color().getAlpha() != 0) {
            this.worldPointRender(graphics, this.plugin.tile1, this.config.tile1Color());
        }
        if (this.config.tile2Color().getAlpha() != 0) {
            this.worldPointRender(graphics, this.plugin.tile2, this.config.tile2Color());
        }
        if (!this.plugin.itemSwitches.get(this.plugin.activeSwitch).isEmpty()) {
            this.itemSwitchRender(graphics, this.plugin.tile1, this.plugin.itemSwitches.get(this.plugin.activeSwitch));
        }
        this.drawAreaBorder(graphics, this.plugin.gameArea);
        return null;
    }

    private void worldPointRender(Graphics2D graphics, WorldPoint p, Color c) {
        if (p == null) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)p);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        BasicStroke stroke = new BasicStroke(3.0f);
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)c, (Stroke)stroke);
        }
    }

    private void drawAreaBorder(Graphics2D graphics, WorldArea a) {
        LocalPoint[] corners = this.areaToLocalPoints(a);
        if (corners == null) {
            return;
        }
        int[] pathX = new int[5];
        int[] pathY = new int[5];
        for (int i = 0; i < 4; ++i) {
            int plane = a.getPlane();
            Point p = Perspective.localToCanvas((Client)this.client, (LocalPoint)corners[i], (int)plane);
            if (p == null) {
                return;
            }
            pathX[i] = p.getX();
            pathY[i] = p.getY();
        }
        pathX[4] = pathX[0];
        pathY[4] = pathY[0];
        graphics.setColor(this.config.borderColor());
        BasicStroke stroke = new BasicStroke(1.0f);
        graphics.setStroke(stroke);
        graphics.drawPolyline(pathX, pathY, 5);
    }

    void itemSwitchRender(Graphics2D graphics, WorldPoint wp, ItemSwitch itemSwitch) {
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)wp);
        if (lp == null || itemSwitch.icon == null) {
            return;
        }
        Point sp = Perspective.localToCanvas((Client)this.client, (LocalPoint)lp, (int)this.plugin.gameArea.getPlane(), (int)0);
        if (sp == null) {
            return;
        }
        OverlayUtil.renderImageLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)lp, (BufferedImage)itemSwitch.icon, (int)0);
        int ticksRemaining = this.plugin.switchTick + this.config.switchRate() - this.plugin.tickCounter;
        if (!this.plugin.switchPattern.isEmpty()) {
            ticksRemaining = this.plugin.patternTicksRemaining();
        }
        if (ticksRemaining >= 0) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)sp, (String)String.valueOf(ticksRemaining), (Color)Color.WHITE);
        }
    }

    LocalPoint[] areaToLocalPoints(WorldArea a) {
        LocalPoint[] corners = new LocalPoint[4];
        int lts = 64;
        corners[0] = LocalPoint.fromWorld((Client)this.client, (int)a.getX(), (int)a.getY());
        corners[1] = LocalPoint.fromWorld((Client)this.client, (int)(a.getX() + a.getWidth() - 1), (int)a.getY());
        corners[2] = LocalPoint.fromWorld((Client)this.client, (int)(a.getX() + a.getWidth() - 1), (int)(a.getY() + a.getHeight() - 1));
        corners[3] = LocalPoint.fromWorld((Client)this.client, (int)a.getX(), (int)(a.getY() + a.getHeight() - 1));
        for (int i = 0; i < 4; ++i) {
            if (corners[i] != null) continue;
            return null;
        }
        corners[0] = this.moveLocalPoint(corners[0], -lts, -lts);
        corners[1] = this.moveLocalPoint(corners[1], lts, -lts);
        corners[2] = this.moveLocalPoint(corners[2], lts, lts);
        corners[3] = this.moveLocalPoint(corners[3], -lts, lts);
        return corners;
    }

    LocalPoint moveLocalPoint(LocalPoint p, int dx, int dy) {
        return new LocalPoint(p.getX() + dx, p.getY() + dy);
    }
}

