/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.DeltaExtras;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ImmutableMapValue;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public final class MessageExtras {
    private static final String TAG = MessageExtras.class.getName();
    private static final String DELTA = "delta";
    private final DeltaExtras delta;
    private final JsonObject jsonObject;

    public MessageExtras(JsonObject jsonObject) {
        this(jsonObject, null);
    }

    private MessageExtras(JsonObject jsonObject, DeltaExtras delta) {
        if (null == jsonObject) {
            throw new NullPointerException("jsonObject cannot be null.");
        }
        this.jsonObject = jsonObject;
        this.delta = delta;
    }

    public DeltaExtras getDelta() {
        return this.delta;
    }

    public JsonObject asJsonObject() {
        return this.jsonObject;
    }

    void write(MessagePacker packer) {
        Serialisation.gsonToMsgpack((JsonElement)this.jsonObject, packer);
    }

    static MessageExtras read(MessageUnpacker unpacker) throws IOException {
        JsonElement element;
        Map<Value, Value> map;
        Value deltaValue;
        DeltaExtras delta = null;
        ImmutableValue value = unpacker.unpackValue();
        if (value instanceof ImmutableMapValue && null != (deltaValue = (map = ((ImmutableMapValue)value).map()).get(ValueFactory.newString(DELTA)))) {
            if (!(deltaValue instanceof ImmutableMapValue)) {
                throw new IOException("The delta extras unpacked to the wrong type \"" + deltaValue.getClass() + "\" when expected a map.");
            }
            Map<Value, Value> deltaMap = ((ImmutableMapValue)deltaValue).map();
            delta = DeltaExtras.read(deltaMap);
        }
        if (!((element = Serialisation.msgpackToGson(value)) instanceof JsonObject)) {
            throw new IOException("The extras unpacked to the wrong type \"" + element.getClass() + "\" when expected a JsonObject.");
        }
        JsonObject raw = (JsonObject)element;
        return new MessageExtras(raw, delta);
    }

    static MessageExtras read(JsonObject raw) throws MessageDecodeException {
        DeltaExtras delta = null;
        JsonElement deltaElement = raw.get(DELTA);
        if (deltaElement instanceof JsonObject) {
            delta = DeltaExtras.read((JsonObject)deltaElement);
        } else if (null != deltaElement) {
            throw MessageDecodeException.fromDescription("The value under the delta key is of the wrong type \"" + deltaElement.getClass() + "\" when expected a map.");
        }
        return new MessageExtras(raw, delta);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageExtras that = (MessageExtras)o;
        return Objects.equals(this.jsonObject, that.jsonObject);
    }

    public int hashCode() {
        return Objects.hashCode(this.jsonObject);
    }

    public String toString() {
        return "MessageExtras{delta=" + this.delta + ", raw=" + this.jsonObject + '}';
    }

    public static class Serializer
    implements JsonSerializer<MessageExtras> {
        public JsonElement serialize(MessageExtras src, Type typeOfSrc, JsonSerializationContext context) {
            return src.jsonObject;
        }
    }
}

