/*
 * Decompiled with CFR 0.152.
 */
package com.regionchat;

import com.google.inject.Provides;
import com.regionchat.AblyManager;
import com.regionchat.Region;
import com.regionchat.RegionChatConfig;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.WorldType;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ably Region Chat", description="Talk to others even if they go to another fishing spot!", tags={"chat"})
public class RegionChatPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RegionChatPlugin.class);
    @Inject
    private AblyManager ablyManager;
    @Inject
    private Client client;
    @Inject
    private RegionChatConfig config;
    private final HashMap<String, ArrayList<String>> previousMessages = new HashMap();
    boolean inPvp;
    private final Map<Region, Callable> regionsToConfigs = new HashMap<Region, Callable>();

    protected void startUp() throws Exception {
        this.initRegions();
        this.ablyManager.startConnection();
    }

    protected void shutDown() throws Exception {
        this.ablyManager.closeConnection();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        LocalPoint currentPos = this.client.getLocalPlayer().getLocalLocation();
        WorldPoint currentWorldPos = this.client.getLocalPlayer().getWorldLocation();
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)currentPos);
        boolean foundRegion = false;
        for (Region region : Region.values()) {
            boolean validRegion = false;
            try {
                validRegion = (Boolean)this.regionsToConfigs.get((Object)region).call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!validRegion || !region.getZones().stream().anyMatch(zone -> zone.contains(worldPoint))) continue;
            int regionID = region.getInstancedRegionID(currentWorldPos, worldPoint);
            foundRegion = true;
            Object channelName = "";
            channelName = (String)channelName + this.client.getWorld();
            if (region.isInstance()) {
                channelName = (String)channelName + ":" + regionID;
            }
            this.ablyManager.connectToRegion(region, (String)channelName);
        }
        if (!foundRegion) {
            this.ablyManager.disconnectFromRegions();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        this.inPvp = this.client.getVar(8121) == 1;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        EnumSet wt = this.client.getWorldType();
        if (wt.contains(WorldType.BOUNTY) || wt.contains(WorldType.DEADMAN) || wt.contains(WorldType.PVP) || this.inPvp) {
            return;
        }
        String cleanedName = Text.sanitize((String)event.getName());
        String cleanedMessage = Text.removeTags((String)event.getMessage());
        if (event.getType() != ChatMessageType.PUBLICCHAT || !cleanedName.equals(this.client.getLocalPlayer().getName())) {
            return;
        }
        this.ablyManager.tryUpdateMessages(cleanedName, cleanedMessage);
        this.ablyManager.publishMessage(cleanedMessage);
    }

    @Provides
    RegionChatConfig provideConfig(ConfigManager configManager) {
        return (RegionChatConfig)configManager.getConfig(RegionChatConfig.class);
    }

    private void initRegions() {
        this.regionsToConfigs.put(Region.BARBARIAN_FISHING, this.config::barbFishingBaRegion);
        this.regionsToConfigs.put(Region.ZEAH_RC, this.config::zeahRcRegion);
        this.regionsToConfigs.put(Region.TEMPOROSS, this.config::temporossRegion);
        this.regionsToConfigs.put(Region.MOTHERLODE_MINE, this.config::motherlodeMineRegion);
        this.regionsToConfigs.put(Region.ZALCANO, this.config::zalcanoRegion);
        this.regionsToConfigs.put(Region.SEPULCHRE, this.config::sepulchreRegion);
        this.regionsToConfigs.put(Region.SULLIUSCEP, this.config::sulliuscepRegion);
    }

    public HashMap<String, ArrayList<String>> getPreviousMessages() {
        return this.previousMessages;
    }

    public Map<Region, Callable> getRegionsToConfigs() {
        return this.regionsToConfigs;
    }
}

