/*
 * Decompiled with CFR 0.152.
 */
package com.regionchat;

import com.regionchat.Zone;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public enum Region {
    BARBARIAN_FISHING("barb-fishing-ba", new Zone(new WorldPoint(2495, 3474, 0), new WorldPoint(2527, 3532, 0))),
    TEMPOROSS("tempoross", true, new Zone(12078)),
    ZEAH_RC("zeahrc", new Zone(new WorldPoint(1672, 3814, 0), new WorldPoint(1858, 3903, 0)), new Zone(new WorldPoint(1636, 3848, 0), new WorldPoint(1671, 3902, 0))),
    MOTHERLODE_MINE("motherlode", new Zone(14936)),
    ZALCANO("zalcano", new Zone(12116)),
    SEPULCHRE("sepulchre", new Zone(new WorldPoint(2220, 5760, 0), new WorldPoint(2591, 6039, 3))),
    SULLIUSCEP("sulliuscep", new Zone(new WorldPoint(3627, 3725, 0), new WorldPoint(3697, 3811, 0)));

    private final List<Zone> zones;
    private final String name;
    private final boolean isInstance;

    private Region(String name, Zone ... zone) {
        this.name = name;
        this.zones = Arrays.asList(zone);
        this.isInstance = false;
    }

    private Region(String name, boolean isInstance, Zone ... zone) {
        this.name = name;
        this.zones = Arrays.asList(zone);
        this.isInstance = isInstance;
    }

    public int getInstancedRegionID(WorldPoint realPlayerPoint, WorldPoint instancePlayerPoint) {
        WorldPoint minPoint = this.getZones().get(0).getMinWorldPoint();
        int xDiff = instancePlayerPoint.getX() - minPoint.getX();
        int yDiff = instancePlayerPoint.getY() - minPoint.getY();
        int realMinPointX = realPlayerPoint.getX() - xDiff;
        int realMinPointY = realPlayerPoint.getY() - yDiff;
        WorldPoint realMinPoint = new WorldPoint(realMinPointX, realMinPointY, 0);
        return realMinPoint.getRegionID();
    }

    public List<Zone> getZones() {
        return this.zones;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInstance() {
        return this.isInstance;
    }
}

