/*
 * Decompiled with CFR 0.152.
 */
package com.regionchat;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.regionchat.Region;
import com.regionchat.RegionChatConfig;
import com.regionchat.RegionChatMessage;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.util.JsonUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.WorldType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AblyManager {
    private static final Logger log = LoggerFactory.getLogger(AblyManager.class);
    private final Client client;
    private final Gson gson = new Gson();
    private final Map<String, String> previousMessages = new HashMap<String, String>();
    private final String CHANNEL_NAME_PREFIX = "regionchat";
    private boolean changingChannels;
    @Inject
    ChatMessageManager chatMessageManager;
    private final RegionChatConfig config;
    private AblyRealtime ablyRealtime;
    private Channel ablyRegionChannel;

    @Inject
    public AblyManager(Client client, RegionChatConfig config) {
        this.client = client;
        this.config = config;
    }

    public void startConnection() {
        this.setupAblyInstances();
    }

    public void closeConnection() {
        this.ablyRealtime.close();
        this.ablyRealtime = null;
        this.ablyRegionChannel = null;
    }

    public void publishMessage(String message) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (this.ablyRegionChannel == null) {
            return;
        }
        try {
            JsonObject msg = JsonUtils.object().add("symbol", this.getAccountIcon()).add("username", this.client.getLocalPlayer().getName()).add("message", message).toJson();
            this.ablyRegionChannel.publish("event", msg);
        }
        catch (AblyException err) {
            System.out.println(err.getMessage());
        }
    }

    private void handleMessage(Message message) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.handleAblyMessage(message, this.config.regionChatColour());
        }
    }

    private void handleAblyMessage(Message message, Color color) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        RegionChatMessage msg = (RegionChatMessage)this.gson.fromJson((JsonElement)message.data, RegionChatMessage.class);
        String username = msg.username;
        String receivedMsg = Text.removeTags((String)msg.message);
        if (!this.tryUpdateMessages(username, receivedMsg)) {
            return;
        }
        ChatMessageBuilder chatMessageBuilder = new ChatMessageBuilder().append(color, receivedMsg);
        if (username.length() > 12) {
            return;
        }
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.PUBLICCHAT).name(msg.symbol + msg.username).runeLiteFormattedMessage(chatMessageBuilder.build()).build());
    }

    public boolean tryUpdateMessages(String name, String message) {
        String prevMessage = this.previousMessages.get(name);
        if (message.equals(prevMessage)) {
            return false;
        }
        this.previousMessages.put(name, message);
        return true;
    }

    private void setupAblyInstances() {
        try {
            ClientOptions clientOptions = new ClientOptions();
            clientOptions.authUrl = "https://runelite-regionchat.herokuapp.com/token";
            this.ablyRealtime = new AblyRealtime(clientOptions);
        }
        catch (AblyException e) {
            e.printStackTrace();
        }
    }

    public void connectToRegion(Region region, String world) {
        final String newChannelName = "regionchat:" + world + ":" + region.getName();
        if (this.changingChannels) {
            return;
        }
        if (this.ablyRegionChannel != null && this.ablyRegionChannel.name.equals(newChannelName)) {
            if (this.ablyRegionChannel.state == ChannelState.detached) {
                try {
                    this.ablyRegionChannel.subscribe(this::handleMessage);
                }
                catch (AblyException err) {
                    System.err.println(err.getMessage());
                }
            }
            return;
        }
        this.changingChannels = true;
        if (this.ablyRegionChannel == null) {
            this.ablyRegionChannel = this.ablyRealtime.channels.get(newChannelName);
            this.subscribeToChannel();
            return;
        }
        try {
            this.ablyRegionChannel.unsubscribe();
            this.ablyRegionChannel.detach(new CompletionListener(){

                @Override
                public void onSuccess() {
                    AblyManager.this.ablyRegionChannel = AblyManager.this.ablyRealtime.channels.get(newChannelName);
                    AblyManager.this.subscribeToChannel();
                }

                @Override
                public void onError(ErrorInfo reason) {
                    System.err.println(reason.message);
                    AblyManager.this.changingChannels = false;
                }
            });
        }
        catch (AblyException err) {
            this.changingChannels = false;
            System.err.println(err.getMessage());
        }
    }

    public void disconnectFromRegions() {
        if (this.ablyRegionChannel != null && this.ablyRegionChannel.state == ChannelState.attached) {
            try {
                this.ablyRegionChannel.unsubscribe();
                this.ablyRegionChannel.detach();
            }
            catch (AblyException err) {
                System.err.println(err.getMessage());
            }
        }
    }

    private void subscribeToChannel() {
        try {
            this.ablyRegionChannel.subscribe(this::handleMessage);
        }
        catch (AblyException err) {
            System.err.println(err.getMessage());
        }
        this.changingChannels = false;
    }

    private String getAccountIcon() {
        if (this.client.getWorldType().contains(WorldType.TOURNAMENT_WORLD)) {
            return "<img=33>";
        }
        switch (this.client.getAccountType()) {
            case IRONMAN: {
                return "<img=2>";
            }
            case HARDCORE_IRONMAN: {
                return "<img=10>";
            }
            case ULTIMATE_IRONMAN: {
                return "<img=3>";
            }
        }
        return "";
    }
}

