/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.util.VarInt;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VCDiffHeaderParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCDiffHeaderParser.class);
    public static final short RESULT_SUCCESS = 0;
    public static final short RESULT_END_OF_DATA = -2;
    public static final byte VCD_DECOMPRESS = 1;
    public static final byte VCD_CODETABLE = 2;
    public static final byte VCD_DATACOMP = 1;
    public static final byte VCD_INSTCOMP = 2;
    public static final byte VCD_ADDRCOMP = 4;
    protected short returnCode = 0;
    protected IOException exception;
    protected Integer deltaEncodingLength = 0;
    protected final ByteBuffer buffer;
    protected ByteBuffer deltaEncodingStart;

    public VCDiffHeaderParser(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
    }

    public Byte parseByte() throws IOException {
        if (0 != this.returnCode) {
            return null;
        }
        if (null != this.exception) {
            throw this.exception;
        }
        if (!this.buffer.hasRemaining()) {
            this.returnCode = (short)-2;
            return null;
        }
        return this.buffer.get();
    }

    public Integer parseInt32(String variable_description) throws IOException {
        if (0 != this.returnCode) {
            return null;
        }
        if (null != this.exception) {
            throw this.exception;
        }
        this.buffer.mark();
        try {
            return VarInt.getInt(this.buffer);
        }
        catch (VarInt.VarIntParseException e) {
            this.buffer.reset();
            this.exception = new IOException("Expected " + variable_description + "; found invalid variable-length integer");
            throw this.exception;
        }
        catch (VarInt.VarIntEndOfBufferException e) {
            this.buffer.reset();
            this.returnCode = (short)-2;
            return null;
        }
    }

    public Integer parseUInt32(String variable_description) throws IOException {
        if (0 != this.returnCode) {
            return null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            this.buffer.mark();
            long parsedValue = VarInt.getLong(this.buffer);
            if ((parsedValue & 0xFFFFFFFF00000000L) != 0L) {
                this.buffer.reset();
                this.exception = new IOException(String.format("Value of {} ({}) is too large for unsigned 32-bit integer", variable_description, parsedValue));
                throw this.exception;
            }
            return (int)parsedValue;
        }
        catch (VarInt.VarIntEndOfBufferException e) {
            this.returnCode = (short)-2;
            this.buffer.reset();
        }
        catch (VarInt.VarIntParseException e) {
            this.buffer.reset();
            this.exception = new IOException(String.format("Expected {}; found invalid variable-length integer", variable_description));
            throw this.exception;
        }
        return null;
    }

    public Integer parseChecksum(String variable_description) throws IOException {
        return this.parseUInt32(variable_description);
    }

    public Integer parseSize(String variable_description) throws IOException {
        return this.parseInt32(variable_description);
    }

    public DeltaWindowHeader parseWinIndicatorAndSourceSegment(int dictionary_size, int decoded_target_size, boolean allow_vcd_target) throws IOException {
        Byte win_indicator = this.parseByte();
        if (win_indicator == null) {
            return null;
        }
        int unrecognized_flags = win_indicator & 0xFF & 0xFFFFFFF8;
        if (unrecognized_flags != 0) {
            LOGGER.warn(String.format("Unrecognized win_indicator flags: 0x%02x", unrecognized_flags));
        }
        int source_target_flags = win_indicator & 3;
        switch (source_target_flags) {
            case 1: {
                return this.parseSourceSegmentLengthAndPosition(dictionary_size, win_indicator, "end of dictionary", "dictionary");
            }
            case 2: {
                if (!allow_vcd_target) {
                    this.exception = new IOException("Delta file contains VCD_TARGET flag, which is not allowed by current decoder settings");
                    throw this.exception;
                }
                return this.parseSourceSegmentLengthAndPosition(decoded_target_size, win_indicator, "current target position", "target file");
            }
            case 3: {
                this.exception = new IOException("Win_Indicator must not have both VCD_SOURCE and VCD_TARGET set");
                throw this.exception;
            }
        }
        return new DeltaWindowHeader(win_indicator, 0, 0);
    }

    public Integer ParseWindowLengths() throws IOException {
        if (this.deltaEncodingStart != null) {
            this.exception = new IOException("Internal error: VCDiffHeaderParser.ParseWindowLengths was called twice for the same delta window");
            throw this.exception;
        }
        this.deltaEncodingLength = this.parseSize("length of the delta encoding");
        if (this.deltaEncodingLength == null) {
            return null;
        }
        this.deltaEncodingStart = this.buffer.duplicate();
        return this.parseSize("size of the target window");
    }

    public Integer endOfDeltaWindow() {
        if (this.deltaEncodingStart == null) {
            throw new IllegalStateException("Internal error: VCDiffHeaderParser.GetDeltaWindowEnd was called before ParseWindowLengths");
        }
        return this.deltaEncodingStart.position() + this.deltaEncodingLength;
    }

    public boolean parseDeltaIndicator() throws IOException {
        Byte deltaIndicator = this.parseByte();
        if (deltaIndicator == null) {
            return false;
        }
        if ((deltaIndicator & 7) != 0) {
            this.exception = new IOException("Secondary compression of delta file sections is not supported");
            throw this.exception;
        }
        return true;
    }

    public SectionLengths parseSectionLengths(boolean has_checksum) throws IOException {
        Integer add_and_run_data_length = this.parseSize("length of data for ADDs and RUNs");
        Integer instructions_and_sizes_length = this.parseSize("length of instructions section");
        Integer addresses_length = this.parseSize("length of addresses for COPYs");
        Integer checksum = null;
        if (has_checksum) {
            checksum = this.parseChecksum("Adler32 checksum value");
        }
        if (0 != this.returnCode) {
            return null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.deltaEncodingStart == null) {
            this.exception = new IOException("Internal error: VCDiffHeaderParser.parseSectionLengths was called before ParseWindowLengths");
            throw this.exception;
        }
        long delta_encoding_header_length = this.buffer.position() - this.deltaEncodingStart.position();
        long expected_delta_encoding_length = delta_encoding_header_length + (long)add_and_run_data_length.intValue() + (long)instructions_and_sizes_length.intValue() + (long)addresses_length.intValue();
        if ((long)this.deltaEncodingLength.intValue() != expected_delta_encoding_length) {
            this.exception = new IOException("The length of the delta encoding does not match the size of the header plus the sizes of the data sections");
            throw this.exception;
        }
        return new SectionLengths(add_and_run_data_length, instructions_and_sizes_length, addresses_length, checksum != null ? checksum : 0);
    }

    public short getResult() {
        return this.returnCode;
    }

    public ByteBuffer unparsedData() {
        return this.buffer.duplicate().asReadOnlyBuffer();
    }

    private DeltaWindowHeader parseSourceSegmentLengthAndPosition(long from_size, byte win_indicator, String from_boundary_name, String from_name) throws IOException {
        Integer source_segment_length = this.parseSize("source segment length");
        if (source_segment_length == null) {
            return null;
        }
        if ((long)source_segment_length.intValue() > from_size) {
            this.exception = new IOException(String.format("Source segment length (%d) is larger than %s (%d)", source_segment_length, from_name, from_size));
            throw this.exception;
        }
        Integer source_segment_position = this.parseSize("source segment position");
        if (source_segment_position == null) {
            return null;
        }
        if ((long)source_segment_position.intValue() >= from_size && source_segment_length > 0) {
            this.exception = new IOException(String.format("Source segment position (%d) is past %s (%d)", source_segment_position, from_boundary_name, from_size));
            throw this.exception;
        }
        int source_segment_end = source_segment_position + source_segment_length;
        if ((long)source_segment_end > from_size) {
            this.exception = new IOException(String.format("Source segment end position ({}) is past {} ({})", source_segment_end, from_boundary_name, from_size));
            throw this.exception;
        }
        return new DeltaWindowHeader(win_indicator, source_segment_length, source_segment_position);
    }

    public static final class SectionLengths {
        public final int add_and_run_data_length;
        public final int instructions_and_sizes_length;
        public final int addresses_length;
        public final int checksum;

        public SectionLengths(int add_and_run_data_length, int instructions_and_sizes_length, int addresses_length, int checksum) {
            this.add_and_run_data_length = add_and_run_data_length;
            this.instructions_and_sizes_length = instructions_and_sizes_length;
            this.addresses_length = addresses_length;
            this.checksum = checksum;
        }
    }

    public static final class DeltaWindowHeader {
        public final byte win_indicator;
        public final int source_segment_length;
        public final int source_segment_position;

        public DeltaWindowHeader(byte win_indicator, int source_segment_length, int source_segment_position) {
            this.win_indicator = win_indicator;
            this.source_segment_length = source_segment_length;
            this.source_segment_position = source_segment_position;
        }
    }
}

