/*
 * Decompiled with CFR 0.152.
 */
package degenereaper.rooftoggle;

import com.google.inject.Provides;
import degenereaper.rooftoggle.RoofToggleConfig;
import degenereaper.rooftoggle.RoofToggleKeyListener;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Roof Toggle", description="Allows use of a keybind for toggling roofs on and off without needing to open the in-game settings menu.", tags={"roof", "toggle", "keybind"})
public class RoofTogglePlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private KeyManager keyManager;
    @Inject
    private RoofToggleKeyListener inputListener;
    private boolean currentlyTyping;

    protected boolean getCurrentlyTyping() {
        return this.currentlyTyping;
    }

    protected void setCurrentlyTyping(boolean val) {
        this.currentlyTyping = val;
    }

    @Provides
    RoofToggleConfig getConfig(ConfigManager configManager) {
        return (RoofToggleConfig)configManager.getConfig(RoofToggleConfig.class);
    }

    protected void startUp() throws Exception {
        this.currentlyTyping = false;
        this.keyManager.registerKeyListener((KeyListener)this.inputListener);
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this.inputListener);
    }

    boolean chatboxFocused() {
        Widget chatboxParent = this.client.getWidget(WidgetInfo.CHATBOX_PARENT);
        if (chatboxParent != null && chatboxParent.getOnKeyListener() != null) {
            Widget worldMapSearch = this.client.getWidget(WidgetInfo.WORLD_MAP_SEARCH);
            return worldMapSearch == null || this.client.getVar(190) != 1;
        }
        return false;
    }
}

