/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.daily.dailies;

import java.awt.image.BufferedImage;
import java.util.Random;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import tictac7x.daily.TicTac7xDailyTasksConfig;
import tictac7x.daily.TicTac7xDailyTasksPlugin;
import tictac7x.daily.common.DailyInfobox;

public class RandomRunes
extends DailyInfobox {
    private final String tooltip = "Claim %d random runes from Lundail at Mage Arena bank";

    public RandomRunes(Client client, TicTac7xDailyTasksConfig config, ItemManager itemManager, TicTac7xDailyTasksPlugin plugin) {
        super("lundail_runes", (BufferedImage)itemManager.getImage(RandomRunes.getRandomRuneId()), client, config, plugin);
    }

    private static int getRandomRuneId() {
        int[] rune_ids = new int[]{554, 555, 556, 557, 558, 559, 561, 562, 563, 564, 560};
        int random = new Random().nextInt(rune_ids.length);
        return rune_ids[random];
    }

    @Override
    public boolean isShowing() {
        return this.config.showRandomRunes() && this.isDiaryCompleted(4466) && !this.isDiaryCompleted(4540);
    }

    @Override
    public String getText() {
        return String.valueOf(this.getRandomRunesAmount());
    }

    @Override
    public String getTooltip() {
        return String.format("Claim %d random runes from Lundail at Mage Arena bank", this.getRandomRunesAmount());
    }

    private int getRandomRunesAmount() {
        boolean easy = this.isDiaryCompleted(4466);
        boolean medium = this.isDiaryCompleted(4467);
        boolean hard = this.isDiaryCompleted(4468);
        boolean elite = this.isDiaryCompleted(4469);
        if (easy && medium && hard && elite) {
            return 200;
        }
        if (easy && medium && hard) {
            return 120;
        }
        if (easy && medium) {
            return 80;
        }
        if (easy) {
            return 40;
        }
        return 0;
    }
}

