/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.daily.dailies;

import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import tictac7x.daily.TicTac7xDailyTasksConfig;
import tictac7x.daily.TicTac7xDailyTasksPlugin;
import tictac7x.daily.common.DailyInfobox;

public class OgreArrows
extends DailyInfobox {
    private final String tooltip = "Collect %d ogre arrows from Rantz near Feldip Hills cave";

    public OgreArrows(Client client, TicTac7xDailyTasksConfig config, ItemManager itemManager, TicTac7xDailyTasksPlugin plugin) {
        super("ogre_arrows", (BufferedImage)itemManager.getImage(2866, 1000, false), client, config, plugin);
    }

    @Override
    public boolean isShowing() {
        return this.config.showOgreArrows() && this.isDiaryCompleted(4471) && !this.isDiaryCompleted(4563);
    }

    @Override
    public String getText() {
        return String.valueOf(this.getOgreArrowsAmount());
    }

    @Override
    public String getTooltip() {
        return String.format("Collect %d ogre arrows from Rantz near Feldip Hills cave", this.getOgreArrowsAmount());
    }

    private int getOgreArrowsAmount() {
        boolean easy = this.isDiaryCompleted(4471);
        boolean medium = this.isDiaryCompleted(4472);
        boolean hard = this.isDiaryCompleted(4473);
        boolean elite = this.isDiaryCompleted(4474);
        if (easy && medium && hard && elite) {
            return 150;
        }
        if (easy && medium && hard) {
            return 100;
        }
        if (easy && medium) {
            return 50;
        }
        if (easy) {
            return 25;
        }
        return 0;
    }
}

