/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.daily.dailies;

import java.awt.image.BufferedImage;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import net.runelite.api.Client;
import net.runelite.api.Quest;
import net.runelite.api.QuestState;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import tictac7x.daily.TicTac7xDailyTasksConfig;
import tictac7x.daily.TicTac7xDailyTasksPlugin;
import tictac7x.daily.common.DailyInfobox;

public class KingdomOfMiscellania
extends DailyInfobox {
    private final ConfigManager configManager;
    private final String percentageFormat = "%d%%";
    private final ZoneId timezone = ZoneId.of("Europe/London");
    private final String tooltip = "You need to work harder to increase your kingdom of Miscellania favor: %d%%";
    private final int VARBIT_KINGDOM_APPROVAL = 72;
    private final int FAVOR_MAX = 127;
    private final double FAVOR_LOST_MODIFIER_WITHOUT_ROYAL_TROUBLE = 0.975;
    private final double FAVOR_LOST_MODIFIER_WITH_ROYAL_TROUBLE = 0.99;
    private final int[] MISCELLANIA_REGIONS = new int[]{10044, 10300};

    public KingdomOfMiscellania(Client client, TicTac7xDailyTasksConfig config, ConfigManager configManager, ItemManager itemManager, TicTac7xDailyTasksPlugin plugin) {
        super("kingdom_of_miscellania_percentage", (BufferedImage)itemManager.getImage(405), client, config, plugin);
        this.configManager = configManager;
    }

    @Override
    public boolean isShowing() {
        return this.config.showKingdomOfMiscellania() && Quest.THRONE_OF_MISCELLANIA.getState(this.client) == QuestState.FINISHED && this.getFavorPercentage() <= this.config.showKingdomOfMiscellaniaFavor();
    }

    @Override
    public String getText() {
        return String.format("%d%%", this.getFavorPercentage());
    }

    @Override
    public String getTooltip() {
        return String.format("You need to work harder to increase your kingdom of Miscellania favor: %d%%", this.getFavorPercentage());
    }

    @Override
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarbitId() != 72) {
            return;
        }
        if (Arrays.stream(this.MISCELLANIA_REGIONS).noneMatch(region -> region == this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            return;
        }
        this.configManager.setConfiguration("tictac7x-daily", "miscellania_favor_date", LocalDateTime.now(this.timezone).format(DateTimeFormatter.ISO_LOCAL_DATE));
        this.configManager.setConfiguration("tictac7x-daily", "kingdom_of_miscellania_favor", (Object)event.getValue());
    }

    private int getFavorPercentage() {
        try {
            LocalDate now = LocalDate.now(this.timezone);
            LocalDate visited = LocalDate.parse(this.config.getKingdomOfMiscellaniaFavorDate());
            long days = Math.abs(ChronoUnit.DAYS.between(now, visited));
            int favor = this.config.getKingdomOfMiscellaniaFavor();
            int i = 0;
            while ((long)i < days) {
                favor = (int)Math.round((double)favor * (Quest.ROYAL_TROUBLE.getState(this.client) == QuestState.FINISHED ? 0.99 : 0.975));
                ++i;
            }
            return favor * 100 / 127;
        }
        catch (Exception ignored) {
            return 0;
        }
    }
}

