/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.daily.dailies;

import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import tictac7x.daily.TicTac7xDailyTasksConfig;
import tictac7x.daily.TicTac7xDailyTasksPlugin;
import tictac7x.daily.common.DailyInfobox;

public class ExplorersRingAlchemy
extends DailyInfobox {
    private final String tooltip = "You have %d alchemy uses left on your Explorers ring";

    public ExplorersRingAlchemy(Client client, TicTac7xDailyTasksConfig config, ItemManager itemManager, TicTac7xDailyTasksPlugin plugin) {
        super("explorers_ring_alchemy", (BufferedImage)itemManager.getImage(ExplorersRingAlchemy.getPlayerExplorerRingId(client)), client, config, plugin);
    }

    private static int getPlayerExplorerRingId(Client client) {
        boolean elite;
        boolean easy = client.getVarbitValue(4495) == 1;
        boolean medium = client.getVarbitValue(4496) == 1;
        boolean hard = client.getVarbitValue(4497) == 1;
        boolean bl = elite = client.getVarbitValue(4498) == 1;
        if (easy && medium && hard && elite) {
            return 13128;
        }
        if (easy && medium && hard) {
            return 13127;
        }
        if (easy && medium) {
            return 13126;
        }
        return 13125;
    }

    @Override
    public boolean isShowing() {
        return this.config.showExplorersRingAlchemy() && this.isDiaryCompleted(4495) && this.getRemainingAlchemyUses() > 0;
    }

    @Override
    public String getText() {
        return String.valueOf(this.getRemainingAlchemyUses());
    }

    @Override
    public String getTooltip() {
        return String.format("You have %d alchemy uses left on your Explorers ring", this.getRemainingAlchemyUses());
    }

    private int getRemainingAlchemyUses() {
        return 30 - this.client.getVarbitValue(4554);
    }
}

