/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.daily.dailies;

import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import tictac7x.daily.TicTac7xDailyTasksConfig;
import tictac7x.daily.TicTac7xDailyTasksPlugin;
import tictac7x.daily.common.DailyInfobox;

public class BowStrings
extends DailyInfobox {
    private final String tooltip = "Exchange flax to %d bow strings from the Flax Keeper at Seers Village";

    public BowStrings(Client client, TicTac7xDailyTasksConfig config, ItemManager itemManager, TicTac7xDailyTasksPlugin plugin) {
        super("bow_strings", (BufferedImage)itemManager.getImage(1777), client, config, plugin);
    }

    @Override
    public boolean isShowing() {
        return this.config.showBowStrings() && this.isDiaryCompleted(4475) && this.client.getVarbitValue(4559) == 0;
    }

    @Override
    public String getText() {
        return String.valueOf(this.getRemainingBowStringsAmount());
    }

    @Override
    public String getTooltip() {
        return String.format("Exchange flax to %d bow strings from the Flax Keeper at Seers Village", this.getRemainingBowStringsAmount());
    }

    private int getRemainingBowStringsAmount() {
        boolean easy = this.isDiaryCompleted(4475);
        boolean medium = this.isDiaryCompleted(4476);
        boolean hard = this.isDiaryCompleted(4477);
        boolean elite = this.isDiaryCompleted(4478);
        if (easy && medium && hard && elite) {
            return 250;
        }
        if (easy && medium && hard) {
            return 120;
        }
        if (easy && medium) {
            return 60;
        }
        if (easy) {
            return 30;
        }
        return 0;
    }
}

