/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.daily.dailies;

import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import tictac7x.daily.TicTac7xDailyTasksConfig;
import tictac7x.daily.TicTac7xDailyTasksPlugin;
import tictac7x.daily.common.DailyInfobox;

public class Battlestaves
extends DailyInfobox {
    private final String tooltip = "Buy %d battlestaves from Zaff at Varrock for %d,000 coins";

    public Battlestaves(Client client, TicTac7xDailyTasksConfig config, ItemManager itemManager, TicTac7xDailyTasksPlugin plugin) {
        super("battlestaves", (BufferedImage)itemManager.getImage(1391), client, config, plugin);
    }

    @Override
    public boolean isShowing() {
        return this.config.showBattlestaves() && !this.isDiaryCompleted(4539);
    }

    @Override
    public String getText() {
        return String.valueOf(this.getRemainingBattlestavesAmount());
    }

    @Override
    public String getTooltip() {
        return String.format("Buy %d battlestaves from Zaff at Varrock for %d,000 coins", this.getRemainingBattlestavesAmount(), this.getRemainingBattlestavesAmount() * 7);
    }

    private int getRemainingBattlestavesAmount() {
        boolean easy = this.isDiaryCompleted(4479);
        boolean medium = this.isDiaryCompleted(4480);
        boolean hard = this.isDiaryCompleted(4481);
        boolean elite = this.isDiaryCompleted(4482);
        if (easy && medium && hard && elite) {
            return 120;
        }
        if (easy && medium && hard) {
            return 60;
        }
        if (easy && medium) {
            return 30;
        }
        if (easy) {
            return 15;
        }
        return 5;
    }
}

