/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.daily;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import tictac7x.daily.TicTac7xDailyTasksConfig;
import tictac7x.daily.common.DailyInfobox;
import tictac7x.daily.dailies.Battlestaves;
import tictac7x.daily.dailies.BowStrings;
import tictac7x.daily.dailies.BucketsOfSand;
import tictac7x.daily.dailies.BucketsOfSlime;
import tictac7x.daily.dailies.Dynamite;
import tictac7x.daily.dailies.ExplorersRingAlchemy;
import tictac7x.daily.dailies.HerbBoxes;
import tictac7x.daily.dailies.ImplingJars;
import tictac7x.daily.dailies.KingdomOfMiscellania;
import tictac7x.daily.dailies.OgreArrows;
import tictac7x.daily.dailies.PureEssence;
import tictac7x.daily.dailies.RandomRunes;

@PluginDescriptor(configName="TicTac7xDailyPlugin", name="Daily Tasks", description="Daily infoboxes to annoy you to do your tasks", tags={"daily", "battlestaves", "battlestaff", "bowstring", "buckets", "sand", "slime", "bone", "bonemeal", "dynamite", "herb", "boxes", "nmz", "impling", "jar", "kingdom", "ogre", "rantz", "essence", "runes", "explorer"})
public class TicTac7xDailyTasksPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private TicTac7xDailyTasksConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    private final String plugin_version = "v0.3";
    private final String plugin_message = "<colHIGHLIGHT>Daily Tasks v0.3:<br><colHIGHLIGHT>* New daily to remind you buy 10 impling jars from Elnock Inquisitor.<br><colHIGHLIGHT>* New daily to remind you to use explorers ring alchemy charges.";
    private DailyInfobox[] dailyInfoboxes = new DailyInfobox[0];

    @Provides
    TicTac7xDailyTasksConfig provideConfig(ConfigManager configManager) {
        return (TicTac7xDailyTasksConfig)configManager.getConfig(TicTac7xDailyTasksConfig.class);
    }

    protected void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.generateInfoboxes();
        }
    }

    protected void shutDown() {
        this.removeOldInfoboxes();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        for (DailyInfobox infobox : this.dailyInfoboxes) {
            infobox.onVarbitChanged(event);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.generateInfoboxes();
        if (!this.config.getVersion().isEmpty() && !this.config.getVersion().equals("v0.3")) {
            this.configManager.setConfiguration("tictac7x-daily", "version", "v0.3");
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage("<colHIGHLIGHT>Daily Tasks v0.3:<br><colHIGHLIGHT>* New daily to remind you buy 10 impling jars from Elnock Inquisitor.<br><colHIGHLIGHT>* New daily to remind you to use explorers ring alchemy charges.").build());
        }
    }

    private void generateInfoboxes() {
        new Thread(() -> {
            try {
                Thread.sleep(1200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clientThread.invokeLater(() -> {
                this.removeOldInfoboxes();
                for (DailyInfobox infobox : this.dailyInfoboxes = new DailyInfobox[]{new Battlestaves(this.client, this.config, this.itemManager, this), new BucketsOfSand(this.client, this.config, this.itemManager, this), new PureEssence(this.client, this.config, this.itemManager, this), new BucketsOfSlime(this.client, this.config, this.itemManager, this), new OgreArrows(this.client, this.config, this.itemManager, this), new BowStrings(this.client, this.config, this.itemManager, this), new Dynamite(this.client, this.config, this.itemManager, this), new RandomRunes(this.client, this.config, this.itemManager, this), new HerbBoxes(this.client, this.config, this.itemManager, this), new KingdomOfMiscellania(this.client, this.config, this.configManager, this.itemManager, this), new ImplingJars(this.client, this.config, this.itemManager, this), new ExplorersRingAlchemy(this.client, this.config, this.itemManager, this)}) {
                    this.infoBoxManager.addInfoBox((InfoBox)infobox);
                }
            });
        }).start();
    }

    private void removeOldInfoboxes() {
        for (DailyInfobox infobox : this.dailyInfoboxes) {
            this.infoBoxManager.removeInfoBox((InfoBox)infobox);
        }
    }
}

