/*
 * Decompiled with CFR 0.152.
 */
package com.casketsounds;

import com.casketsounds.CasketSoundsConfig;
import com.casketsounds.FileManager;
import com.casketsounds.Sound;
import com.casketsounds.SoundEngine;
import com.google.inject.Provides;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Casket Sounds")
public class CasketSoundsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CasketSoundsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CasketSoundsConfig config;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private OkHttpClient okHttpClient;

    protected void startUp() throws Exception {
        this.executor.submit(() -> {
            FileManager.ensureDownloadDirectoryExists();
            FileManager.downloadAllMissingSounds(this.okHttpClient);
        });
        log.info("CasketSounds started!");
    }

    protected void shutDown() throws Exception {
        this.soundEngine.close();
        log.info("CasketSounds stopped!");
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.MESBOX && chatMessage.getMessage().toLowerCase().contains("casket")) {
            int whichSound = ThreadLocalRandom.current().nextInt(1, 4);
            switch (whichSound) {
                case 2: {
                    log.info("Playing CASKET2 sound.");
                    this.soundEngine.playClip(Sound.CASKET2);
                    break;
                }
                case 3: {
                    log.info("Playing CASKET3 sound.");
                    this.soundEngine.playClip(Sound.CASKET3);
                    break;
                }
                default: {
                    log.info("Playing default CASKET sound.");
                    this.soundEngine.playClip(Sound.CASKET);
                }
            }
        }
    }

    @Provides
    CasketSoundsConfig provideConfig(ConfigManager configManager) {
        return (CasketSoundsConfig)configManager.getConfig(CasketSoundsConfig.class);
    }
}

