/*
 * Decompiled with CFR 0.152.
 */
package com.coxscavcalculator;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.util.ImageUtil;

public class CoxScavCalculatorPanel
extends PluginPanel {
    private int plankCount = 0;
    private int buchuCount = 0;
    private int golparCount = 0;
    private int noxiferCount = 0;
    private int juiceCount = 0;
    private int cicelyCount = 0;
    private int mushroomCount = 0;
    private JComboBox chestCombo = new JComboBox();
    private FlatTextField aidText = new FlatTextField();
    private FlatTextField enhanceText = new FlatTextField();
    private FlatTextField overloadText = new FlatTextField();
    private FlatTextField revitText = new FlatTextField();
    private JPanel itemPanel = new JPanel();

    @Inject
    private CoxScavCalculatorPanel() {
        this.setPreferredSize(new Dimension(200, 600));
        this.add(this.createTitleLabel("Cox Scav Helper"));
        this.styleBoxes();
        this.itemPanel.setLayout(new GridLayout(0, 4));
        this.itemPanel.setPreferredSize(new Dimension(200, 100));
        this.setItemPanel();
        String[] chestData = new String[]{"Private Level 0 Construction", "Small Level 30 Construction", "Medium Level 60 Construction", "Large Level 90 Construction", "Massive Level 99 Construction"};
        this.chestCombo.setModel(new DefaultComboBoxModel<String>(chestData));
        this.chestCombo.setSelectedIndex(0);
        this.add(this.getChest());
        this.add(this.chestCombo);
        this.add(this.getAid());
        this.add((Component)this.aidText);
        this.add(this.getEnhance());
        this.add((Component)this.enhanceText);
        this.add(this.getOverload());
        this.add((Component)this.overloadText);
        this.add(this.getRevit());
        this.add((Component)this.revitText);
        this.add(this.createEnterButton());
        this.add(this.itemPanel);
    }

    private JButton createEnterButton() {
        final JButton label = new JButton("Calculate");
        label.setPreferredSize(new Dimension(205, 30));
        label.setFocusable(false);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    label.setText("Wait...");
                    CoxScavCalculatorPanel.this.runCalculation();
                    CoxScavCalculatorPanel.this.setItemPanel();
                    label.setText("Calculate");
                }
            }
        });
        return label;
    }

    private void styleBoxes() {
        this.chestCombo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.aidText.setPreferredSize(new Dimension(205, 30));
        this.aidText.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.aidText.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.aidText.setText("0");
        this.enhanceText.setPreferredSize(new Dimension(205, 30));
        this.enhanceText.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.enhanceText.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.enhanceText.setText("0");
        this.overloadText.setPreferredSize(new Dimension(205, 30));
        this.overloadText.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.overloadText.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.overloadText.setText("0");
        this.revitText.setPreferredSize(new Dimension(205, 30));
        this.revitText.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.revitText.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.revitText.setText("0");
    }

    private JLabel getChest() {
        JLabel label = new JLabel();
        label.setToolTipText("Chest");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Chest Tier");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Chest.png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getAid() {
        JLabel label = new JLabel();
        label.setToolTipText("Xeric's Aid");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Xeric's Aid #");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Xerics_aid.png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getEnhance() {
        JLabel label = new JLabel();
        label.setToolTipText("Prayer Enhance");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Prayer Enhance #");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Prayer_enhance.png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getOverload() {
        JLabel label = new JLabel();
        label.setToolTipText("Overload");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Overload #");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Overload.png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getRevit() {
        JLabel label = new JLabel();
        label.setToolTipText("Revitalisation");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Revitalisation #");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Revitalisation.png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel createTitleLabel(String title) {
        JLabel label = new JLabel(title, 0);
        label.setPreferredSize(new Dimension(200, 20));
        label.setForeground(Color.yellow);
        return label;
    }

    private void runCalculation() {
        int revit;
        int overload;
        int enhance;
        int aid;
        try {
            aid = Integer.parseInt(this.aidText.getText());
        }
        catch (Exception e) {
            aid = 0;
            this.aidText.setText("0");
        }
        try {
            enhance = Integer.parseInt(this.enhanceText.getText());
        }
        catch (Exception e) {
            enhance = 0;
            this.enhanceText.setText("0");
        }
        try {
            overload = Integer.parseInt(this.overloadText.getText());
        }
        catch (Exception e) {
            overload = 0;
            this.overloadText.setText("0");
        }
        try {
            revit = Integer.parseInt(this.revitText.getText());
        }
        catch (Exception e) {
            revit = 0;
            this.revitText.setText("0");
        }
        this.plankCount = 0;
        this.buchuCount = 0;
        this.golparCount = 0;
        this.noxiferCount = 0;
        this.juiceCount = 0;
        this.cicelyCount = 0;
        this.mushroomCount = 0;
        this.plankCount += 2 * this.chestCombo.getSelectedIndex();
        this.buchuCount += aid;
        this.juiceCount += aid;
        this.buchuCount += enhance;
        this.cicelyCount += enhance;
        this.noxiferCount += overload;
        this.golparCount += overload;
        this.mushroomCount += overload;
        this.golparCount += overload;
        this.cicelyCount += overload;
        this.golparCount += overload;
        this.juiceCount += overload;
        this.buchuCount += revit;
        this.mushroomCount += revit;
    }

    private void setItemPanel() {
        this.itemPanel.removeAll();
        this.itemPanel.add(this.createItemLabel("Plank", String.valueOf(this.plankCount)));
        this.itemPanel.add(this.createItemLabel("Buchu", String.valueOf(this.buchuCount)));
        this.itemPanel.add(this.createItemLabel("Golpar", String.valueOf(this.golparCount)));
        this.itemPanel.add(this.createItemLabel("Noxifer", String.valueOf(this.noxiferCount)));
        this.itemPanel.add(this.createItemLabel("Juice", String.valueOf(this.juiceCount)));
        this.itemPanel.add(this.createItemLabel("Cicely", String.valueOf(this.cicelyCount)));
        this.itemPanel.add(this.createItemLabel("Mushroom", String.valueOf(this.mushroomCount)));
    }

    private JLabel createItemLabel(String name, String qty) {
        JLabel label = new JLabel();
        label.setToolTipText(name);
        label.setHorizontalAlignment(0);
        label.setBorder(BorderFactory.createLineBorder(ColorScheme.DARK_GRAY_COLOR, 2));
        ImageIcon icon = new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)(name + ".png")));
        label.setIcon(this.getLabeledIcon(icon, qty));
        return label;
    }

    private Icon getLabeledIcon(Icon old, String qty) {
        int w = old.getIconWidth();
        int h = old.getIconHeight();
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g2d = img.createGraphics();
        old.paintIcon(null, g2d, 0, 0);
        g2d.setPaint(Color.white);
        g2d.drawString(qty, 0, 10);
        g2d.dispose();
        return new ImageIcon(img.getScaledInstance(w, h, 4));
    }
}

