/*
 * Decompiled with CFR 0.152.
 */
package dekvall.worldhider;

import com.google.inject.Provides;
import dekvall.worldhider.WorldHiderConfig;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.FriendContainer;
import net.runelite.api.GameState;
import net.runelite.api.NameableContainer;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="World Hider")
public class WorldHiderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WorldHiderPlugin.class);
    private static final int WORLD_HOPPER_BUILD = 892;
    private static final int DRAW_FRIEND_ENTRIES = 125;
    private static final int BUILD_CC = 1658;
    private static final int MISSING_FLAG_SPRITE = 1132;
    private static final int FLAG_ORIGINAL_X = 44;
    private static final int VARP_MEMBERSHIP_DAYS = 1780;
    @Inject
    private Client client;
    @Inject
    private WorldHiderConfig config;
    @Inject
    private ClientThread clientThread;
    private int randomWorld = this.getRandomWorld();

    protected void startUp() throws Exception {
        log.info("World Hider started!");
    }

    protected void shutDown() throws Exception {
        log.info("World Hider stopped!");
    }

    @Provides
    WorldHiderConfig provideConfig(ConfigManager configManager) {
        return (WorldHiderConfig)configManager.getConfig(WorldHiderConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.randomWorld = this.getRandomWorld();
        }
    }

    @Subscribe
    public void onClientTick(ClientTick tick) {
        NameableContainer ignoreContainer;
        int ignoreCount;
        boolean isMember = this.client.getVarpValue(1780) > 0;
        FriendContainer friendContainer = this.client.getFriendContainer();
        int friendCount = friendContainer.getCount();
        if (friendCount >= 0) {
            int limit = isMember ? 400 : 200;
            String title = "Friends - W" + (Serializable)(this.config.randomWorld() ? Integer.valueOf(this.randomWorld) : "XXX") + " (" + friendCount + "/" + limit + ")";
            this.setFriendsListTitle(title);
        }
        if ((ignoreCount = (ignoreContainer = this.client.getIgnoreContainer()).getCount()) >= 0) {
            int limit = isMember ? 400 : 200;
            String title = "Ignores - W" + (Serializable)(this.config.randomWorld() ? Integer.valueOf(this.randomWorld) : "XXX") + " (" + ignoreCount + "/" + limit + ")";
            this.setIgnoreListTitle(title);
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        switch (event.getScriptId()) {
            case 125: {
                this.clientThread.invokeLater(this::recolorFriends);
                break;
            }
            case 892: {
                this.clientThread.invoke(this::killWorldHopper);
                this.clientThread.invoke(this::hideHopperWorlds);
                break;
            }
            case 1658: {
                this.clientThread.invoke(this::hideClanWorlds);
            }
        }
    }

    private void recolorFriends() {
        Widget friendsList = this.client.getWidget(429, 11);
        if (friendsList == null) {
            return;
        }
        Widget[] friends = friendsList.getDynamicChildren();
        for (int i = 0; i < friends.length; i += 2) {
            if (friends[i].getText().contains("Offline") || !friends[i].getName().isEmpty()) continue;
            if (this.config.massHide()) {
                friends[i].setText("World XXX");
            }
            friends[i].setTextColor(0xFFFF00);
        }
    }

    private void killWorldHopper() {
        Widget worldHopper = this.client.getWidget(69, 3);
        if (worldHopper == null) {
            return;
        }
        worldHopper.setText("Current world - " + (Serializable)(this.config.randomWorld() ? Integer.valueOf(this.randomWorld) : "XXX"));
        worldHopper.setOnVarTransmitListener((Object[])null);
        Widget worldList = this.client.getWidget(69, 18);
        if (worldList == null) {
            return;
        }
        for (Widget entry : worldList.getDynamicChildren()) {
            if (entry.getTextColor() != 901389) continue;
            entry.setTextColor(0);
        }
    }

    private void hideClanWorlds() {
        Widget[] entries;
        Widget clan = this.client.getWidget(WidgetInfo.FRIENDS_CHAT_LIST);
        if (clan == null) {
            return;
        }
        for (Widget entry : entries = clan.getDynamicChildren()) {
            if (!entry.getText().startsWith("W")) continue;
            if (this.config.massHide()) {
                entry.setText("WXXX");
            }
            entry.setTextColor(0xFFFF64);
        }
    }

    private void hideHopperWorlds() {
        Widget[] entries;
        if (!this.config.hideList()) {
            return;
        }
        Widget list = this.client.getWidget(69, 19);
        if (list == null) {
            return;
        }
        for (Widget entry : entries = list.getDynamicChildren()) {
            entry.setText("XXX");
            if (entry.getOriginalX() != 44 || !this.config.hideFlags()) continue;
            entry.setSpriteId(1132);
        }
        Widget listLabel = this.client.getWidget(69, 19);
        if (listLabel == null) {
            return;
        }
        Widget worldTooltip = this.client.getWidget(69, 26);
        worldTooltip.setHidden(true);
        if (this.config.hideScrollbar()) {
            Widget[] scrollEntries;
            Widget scrollbar = this.client.getWidget(69, 20);
            if (scrollbar == null) {
                return;
            }
            for (Widget entry : scrollEntries = scrollbar.getDynamicChildren()) {
                entry.setSpriteId(-1);
            }
        }
    }

    private int getRandomWorld() {
        return ThreadLocalRandom.current().nextInt(301, 500);
    }

    private void setFriendsListTitle(String title) {
        Widget friendListTitleWidget = this.client.getWidget(WidgetInfo.FRIEND_CHAT_TITLE);
        if (friendListTitleWidget != null) {
            friendListTitleWidget.setText(title);
        }
    }

    private void setIgnoreListTitle(String title) {
        Widget ignoreTitleWidget = this.client.getWidget(WidgetInfo.IGNORE_TITLE);
        if (ignoreTitleWidget != null) {
            ignoreTitleWidget.setText(title);
        }
    }
}

