/*
 * Decompiled with CFR 0.152.
 */
package com.preeocxp;

import com.google.inject.Provides;
import com.preeocxp.PreEocXpConfig;
import com.preeocxp.PreEocXpOverlay;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.api.events.FakeXpDrop;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Pre Eoc Xp Drops", description="Customize Xp drops and display the 2010 xp Counter (WIP - currently just 2010 xp drops)", tags={"experience", "levels", "overlay", "xp drop"}, enabledByDefault=false)
@PluginDependency(value=XpTrackerPlugin.class)
public class PreEocXpPlugin
extends Plugin {
    private static long loginXp = 0L;
    long preXp = 0L;
    public static int xpDrop;
    public static int tickCounter;
    public static boolean sentXp;
    private static boolean configWasChanged;
    public static int newTick;
    public static long skillXp;
    @Inject
    private PreEocXpConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PreEocXpOverlay overlay;
    @Inject
    Client client;

    @Provides
    PreEocXpConfig getConfig(ConfigManager configManager) {
        return (PreEocXpConfig)configManager.getConfig(PreEocXpConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.client.getWidget(WidgetInfo.EXPERIENCE_TRACKER).setHidden(false);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        ++tickCounter;
        long overallXp = this.client.getOverallExperience();
        if (this.config.displaySkill() == Skill.OVERALL) {
            skillXp = overallXp;
        }
        this.preXp = loginXp;
        if (loginXp != 0L && overallXp - this.preXp <= 0L) {
            return;
        }
        if (loginXp != 0L) {
            xpDrop = (int)(overallXp - this.preXp);
            sentXp = true;
            loginXp = this.preXp = overallXp;
        } else {
            loginXp = this.client.getOverallExperience();
            sentXp = true;
        }
    }

    @Subscribe
    public void onFakeXpDrop(FakeXpDrop event) {
        xpDrop = newTick == tickCounter ? (xpDrop += event.getXp()) : event.getXp();
        newTick = tickCounter;
        sentXp = true;
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        Widget xpDisplay = this.client.getWidget(WidgetInfo.EXPERIENCE_TRACKER);
        if (xpDisplay != null) {
            xpDisplay.setHidden(true);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (this.config.displaySkill() != Skill.OVERALL) {
            skillXp = this.client.getSkillExperience(this.config.displaySkill());
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        PreEocXpPlugin.setConfigUpdateState(true);
        if (this.config.displaySkill() != Skill.OVERALL) {
            skillXp = this.client.getSkillExperience(this.config.displaySkill());
        }
    }

    public static boolean getConfigUpdateState() {
        return configWasChanged;
    }

    public static void setConfigUpdateState(boolean configSetter) {
        configWasChanged = configSetter;
    }

    public static long getLoginXp() {
        return loginXp;
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS)
    private void resetState() {
        loginXp = 0L;
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getEntry().getMenuAction() != MenuAction.RUNELITE_OVERLAY || event.getOverlay() != this.overlay) {
            return;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGGED_IN: {
                loginXp = this.client.getOverallExperience();
                this.startUp();
            }
            case HOPPING: 
            case LOGGING_IN: 
            case LOGIN_SCREEN: {
                this.resetState();
            }
        }
    }

    static {
        tickCounter = 0;
        sentXp = true;
        configWasChanged = true;
    }
}

