/*
 * Decompiled with CFR 0.152.
 */
package com.preeocxp;

import com.preeocxp.PreEocXp2012Overlay;
import com.preeocxp.PreEocXpConfig;
import com.preeocxp.PreEocXpPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ImageUtil;

public class PreEocXpOverlay
extends Overlay {
    private static final int MINIMUM_STEP = 8;
    private static final int TOOLTIP_RECT_SIZE_X = 80;
    private static final int OVERLAY_RECT_SIZE_X = 110;
    private static final int OVERLAY_RECT_SIZE_Y = 14;
    private static final Color OVERLAY_COLOR = new Color(0, 0, 0, 0);
    private final Client client;
    private final PreEocXpPlugin plugin;
    private final PreEocXpConfig config;
    private final XpTrackerService xpTrackerService;
    private final TooltipManager tooltipManager;
    private final Tooltip xpTooltip = new Tooltip((LayoutableRenderableEntity)new PanelComponent());
    private Skill skillChosen = Skill.OVERALL;
    private static int lotsThreshold = 100000000;
    private static int shrinkValue = 0;
    private static final LinkedList<Integer> xpStored = new LinkedList();
    private static final LinkedList<Long> timeValStored = new LinkedList();
    private static int xpDropWidth;
    final BufferedImage xpBarMidImage = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/xpBarMid.png");
    final BufferedImage xpBarLeftImage = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/xpBarLeft.png");
    final BufferedImage xpBarRightImage = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/xpBarRight.png");
    Font runescapeChatFont;
    Font runescapeSmallFont;
    Font rsXpDropFont;
    private static float dropSize;

    @Inject
    private PreEocXpOverlay(Client client, PreEocXpPlugin plugin, PreEocXpConfig config, XpTrackerService xpTrackerService, TooltipManager tooltipManager) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.xpTrackerService = xpTrackerService;
        this.tooltipManager = tooltipManager;
        this.xpTooltip.getComponent().setPreferredSize(new Dimension(80, -30));
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setMovable(true);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterInterface(303);
        this.setPriority(OverlayPriority.HIGH);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "XP Tracker overlay"));
    }

    public void registerFont() {
        try {
            InputStream runescapeChat = ((Object)((Object)this)).getClass().getResourceAsStream("/runescape_chat.ttf");
            InputStream runescapeSmall = ((Object)((Object)this)).getClass().getResourceAsStream("/runescape_small.ttf");
            InputStream rsXpDrop = ((Object)((Object)this)).getClass().getResourceAsStream("/rsxpdrop.ttf");
            this.runescapeChatFont = Font.createFont(0, runescapeChat).deriveFont(16.0f);
            this.runescapeSmallFont = Font.createFont(0, runescapeSmall).deriveFont(dropSize);
            this.rsXpDropFont = Font.createFont(0, rsXpDrop).deriveFont(dropSize - 4.0f);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(this.runescapeChatFont);
            ge.registerFont(this.runescapeSmallFont);
            ge.registerFont(this.rsXpDropFont);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
    }

    public void setDropSize() {
        dropSize = this.config.dropSize() == PreEocXpConfig.OptionEnum.REGULAR ? 16.0f : (this.config.dropSize() == PreEocXpConfig.OptionEnum.LARGE ? 20.0f : 24.0f);
    }

    public Dimension render(Graphics2D graphics) {
        if (PreEocXpPlugin.getConfigUpdateState()) {
            this.setDropSize();
            this.registerFont();
            this.skillChosen = this.config.displaySkill();
            lotsThreshold = this.config.lotsLimit();
            PreEocXpPlugin.setConfigUpdateState(false);
        }
        graphics.setFont(this.runescapeChatFont);
        long xpFetched = PreEocXpPlugin.getLoginXp();
        if (xpFetched == 0L) {
            return null;
        }
        int curDrawPosition = 0;
        this.renderRectangle(graphics, curDrawPosition, 0, this.getBounds());
        curDrawPosition += 8;
        return new Dimension(110, 14);
    }

    private void renderRectangle(Graphics2D graphics, int x, int y, Rectangle bounds) {
        graphics.setColor(OVERLAY_COLOR);
        Point mouse = this.client.getMouseCanvasPosition();
        int mouseX = mouse.getX() - bounds.x;
        int mouseY = mouse.getY() - bounds.y;
        if (PreEocXpPlugin.sentXp) {
            PreEocXpPlugin.sentXp = false;
            long startTime = System.currentTimeMillis();
            if (PreEocXpPlugin.xpDrop != 0) {
                timeValStored.add(startTime);
                xpStored.add(PreEocXpPlugin.xpDrop);
                PreEocXpPlugin.xpDrop = 0;
            }
            int n = 0;
            for (int i = 0; i < xpStored.size(); ++i) {
                if (startTime - timeValStored.get(i) > 1800L) {
                    xpStored.remove(n);
                    timeValStored.remove(n);
                    continue;
                }
                ++n;
            }
        } else {
            long currentTime = System.currentTimeMillis();
            int n = 0;
            for (int i = 0; i < xpStored.size(); ++i) {
                if (currentTime - timeValStored.get(i) > 1800L) {
                    xpStored.remove(n);
                    timeValStored.remove(n);
                }
                ++n;
            }
        }
        if (!this.config.onlyCounter()) {
            if (!this.config.enableTwelve()) {
                this.drawTenDrop(graphics, 0, 0);
            } else {
                this.drawTwelveDrop(graphics);
            }
        }
        if (!this.config.onlyDrops()) {
            Rectangle backgroundRectangle = this.drawRectangle(graphics, x, y);
            this.drawXpLabel(graphics, 0, 0);
            if (backgroundRectangle.contains(mouseX, mouseY) && this.config.enableTooltips()) {
                this.drawTooltip();
            }
            if (this.config.onlyCounter()) {
                Widget xpDisplay = this.client.getWidget(WidgetInfo.EXPERIENCE_TRACKER);
                xpDisplay.setHidden(false);
            }
        }
    }

    private void drawXpLabel(Graphics2D graphics, int x, int y) {
        graphics.setFont(this.runescapeChatFont);
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###");
        FontMetrics metrics = graphics.getFontMetrics();
        int drawX = x;
        int drawY = y + 14 - 1;
        Color xpColor = Color.WHITE;
        Color lotsColor = Color.RED;
        int offset = 5;
        int xpLength = (int)(Math.log10(PreEocXpPlugin.skillXp) + 1.0);
        shrinkValue = xpLength < 7 ? 25 : (xpLength < 8 ? 20 : (xpLength < 9 ? 10 : (xpLength > 10 ? -10 : 0)));
        if (PreEocXpPlugin.skillXp > (long)lotsThreshold) {
            shrinkValue = 25;
        }
        if (PreEocXpPlugin.skillXp < (long)lotsThreshold) {
            String formattedXp = decimalFormat.format(PreEocXpPlugin.skillXp);
            int xpWidth = metrics.stringWidth(formattedXp);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(drawX + (110 - (xpWidth + offset)), drawY), (String)formattedXp, (Color)xpColor);
        } else {
            String formattedXp = "Lots!";
            int lotsWidth = metrics.stringWidth(formattedXp);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(drawX + (110 - (lotsWidth + offset)), drawY), (String)formattedXp, (Color)lotsColor);
        }
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(drawX + offset + shrinkValue, drawY), (String)"XP:", (Color)xpColor);
    }

    private void drawTenDrop(Graphics2D graphics, int x, int y) {
        graphics.setFont(this.runescapeSmallFont);
        FontMetrics metrics = graphics.getFontMetrics();
        int drawXVal = x;
        Color dropColor = new Color(250, 141, 17);
        for (int i = 0; i < xpStored.size(); ++i) {
            long animationTimer = Math.min(System.currentTimeMillis() - timeValStored.get(i), 1200L);
            int drawYVal = (int)(animationTimer / 17L) + 24;
            DecimalFormat decimalFormat = new DecimalFormat("###,###,###");
            String skillXpString = decimalFormat.format(xpStored.get(i));
            xpDropWidth = metrics.stringWidth(skillXpString + "xp");
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(drawXVal + (110 - xpDropWidth), drawYVal), (String)(skillXpString + "xp"), (Color)dropColor);
        }
    }

    private void drawTwelveDrop(Graphics2D graphics) {
        graphics.setFont(this.rsXpDropFont);
        int overlayLocationX = this.client.getCenterX() - (int)this.getBounds().getX();
        int overlayLocationY = this.client.getCenterY() - (int)this.getBounds().getY() - 4;
        PreEocXp2012Overlay helper = new PreEocXp2012Overlay(this.plugin);
        for (int i = 0; i < xpStored.size(); ++i) {
            long timePassed = System.currentTimeMillis() - timeValStored.get(i);
            helper.drawTwelveDrop(graphics, overlayLocationX, overlayLocationY, xpStored.get(i), (int)timePassed);
        }
    }

    private Rectangle drawRectangle(Graphics2D graphics, int x, int y) {
        Rectangle rectangle = new Rectangle(110 - shrinkValue, 14);
        rectangle.setLocation(x + shrinkValue, y);
        int imgHeight = this.xpBarMidImage.getHeight();
        int fixedWidth = this.xpBarLeftImage.getWidth();
        int yHeight = y - (imgHeight - 14) / 2;
        graphics.drawImage(this.xpBarMidImage, rectangle.x + fixedWidth, yHeight, rectangle.width - 2 * fixedWidth, imgHeight, null);
        graphics.drawImage((Image)this.xpBarLeftImage, rectangle.x, yHeight, null);
        graphics.drawImage((Image)this.xpBarRightImage, rectangle.x + rectangle.width - fixedWidth, yHeight, null);
        return rectangle;
    }

    private void drawTooltip() {
        PanelComponent xpTooltip = (PanelComponent)this.xpTooltip.getComponent();
        xpTooltip.getChildren().clear();
        xpTooltip.getChildren().add(LineComponent.builder().left(" Skill: " + this.skillChosen.getName()).leftColor(Color.WHITE).build());
        this.tooltipManager.add(this.xpTooltip);
    }

    static {
        dropSize = 16.0f;
    }
}

