/*
 * Decompiled with CFR 0.152.
 */
package com.preeocxp;

import com.preeocxp.PreEocXpPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.util.ColorUtil;

public class PreEocXp2012Overlay
extends Overlay {
    private static int xpDropWidth;

    @Inject
    public PreEocXp2012Overlay(PreEocXpPlugin plugin) {
        super((Plugin)plugin);
    }

    public Dimension render(Graphics2D graphics) {
        return new Dimension();
    }

    public void drawTwelveDrop(Graphics2D graphics, int x, int y, int xpDrop, int timePassed) {
        FontMetrics metrics = graphics.getFontMetrics();
        int drawXVal = x;
        int drawYVal = y + metrics.getHeight() / 2;
        int opacityValue = 255;
        int shadowOpacity = 255;
        Color dropColor = new Color(239, 178, 70);
        Color shadowColor = new Color(0, 0, 0);
        long animationTimer = Math.min(timePassed, 600);
        drawYVal = (int)(-1L * (animationTimer / 4L)) + drawYVal;
        if (timePassed > 600) {
            opacityValue = 255 - (int)((double)(timePassed - 600) / 4.7);
            shadowOpacity = opacityValue - (255 - opacityValue) / 3;
        }
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###");
        String skillXpString = decimalFormat.format(xpDrop);
        String xpDropString = "+" + skillXpString + " xp";
        xpDropWidth = metrics.stringWidth(xpDropString);
        graphics.setColor(ColorUtil.colorWithAlpha((Color)shadowColor, (int)shadowOpacity));
        graphics.drawString(xpDropString, drawXVal - xpDropWidth / 2 + 1, drawYVal + 1);
        graphics.setColor(ColorUtil.colorWithAlpha((Color)dropColor, (int)opacityValue));
        graphics.drawString(xpDropString, drawXVal - xpDropWidth / 2, drawYVal);
    }
}

