/*
 * Decompiled with CFR 0.152.
 */
package com.identificator;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.identificator.IdentificatorConfig;
import com.identificator.IdentificatorOverlay;
import com.identificator.IdentificatorPanel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.NpcOverrides;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Identificator", description="Show IDs for NPCs, objects, animations and more", tags={"id", "identification"})
public class IdentificatorPlugin
extends Plugin {
    private static final String PANEL_DELIMITER = "\t";
    static final String CONFIG_GROUP = "identificator";
    static final int TILE_RADIUS = 20;
    static final List<MenuAction> OBJECT_MENU_TYPES = ImmutableList.of((Object)MenuAction.EXAMINE_OBJECT, (Object)MenuAction.GAME_OBJECT_FIRST_OPTION, (Object)MenuAction.GAME_OBJECT_SECOND_OPTION, (Object)MenuAction.GAME_OBJECT_THIRD_OPTION, (Object)MenuAction.GAME_OBJECT_FOURTH_OPTION, (Object)MenuAction.GAME_OBJECT_FIFTH_OPTION);
    static final List<MenuAction> GROUND_ITEM_MENU_TYPES = ImmutableList.of((Object)MenuAction.EXAMINE_ITEM_GROUND, (Object)MenuAction.GROUND_ITEM_FIRST_OPTION, (Object)MenuAction.GROUND_ITEM_SECOND_OPTION, (Object)MenuAction.GROUND_ITEM_THIRD_OPTION, (Object)MenuAction.GROUND_ITEM_FOURTH_OPTION, (Object)MenuAction.GROUND_ITEM_FIFTH_OPTION);
    String hoverText = null;
    boolean showHoverInfo;
    boolean showOverheadInfo;
    private boolean showMenuInfo;
    boolean triggerWithShift;
    boolean showNpcId;
    boolean showNpcAnimationId;
    boolean showNpcPoseAnimationId;
    boolean showNpcGraphicId;
    boolean showPlayerAnimationId;
    boolean showPlayerPoseAnimationId;
    boolean showPlayerGraphicId;
    boolean showGameObjectId;
    boolean showGroundObjectId;
    boolean showDecorativeObjectId;
    boolean showWallObjectId;
    boolean showGroundItemId;
    boolean showNpcOverrideModelIds;
    boolean showNpcOverrideColours;
    boolean showNpcOverrideTextures;
    Color colourHover;
    Color colourOverhead;
    Color colourMenu;
    private IdentificatorPanel panel;
    private NavigationButton navigationButton;
    private int lastTickCount;
    private int loginTickCount;
    private int lastPlayerAnimationId;
    private int lastPlayerPoseAnimationId;
    private int lastPlayerGraphicId;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private IdentificatorConfig config;
    @Inject
    private IdentificatorOverlay identificatorOverlay;
    @Inject
    private OverlayManager overlayManager;

    @Provides
    IdentificatorConfig provideConfig(ConfigManager configManager) {
        return (IdentificatorConfig)configManager.getConfig(IdentificatorConfig.class);
    }

    protected void startUp() {
        this.loadOptions();
        this.overlayManager.add((Overlay)this.identificatorOverlay);
        this.panel = new IdentificatorPanel();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/panel_icon.png");
        this.navigationButton = NavigationButton.builder().tooltip("Identificator").icon(icon).priority(100).panel((PluginPanel)this.panel).build();
        if (this.config.logging()) {
            this.clientToolbar.addNavigation(this.navigationButton);
        }
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.identificatorOverlay);
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.panel = null;
        this.navigationButton = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup())) {
            return;
        }
        this.loadOptions();
        if ("logging".equals(event.getKey())) {
            if (this.config.logging()) {
                this.clientToolbar.addNavigation(this.navigationButton);
            } else {
                this.clientToolbar.removeNavigation(this.navigationButton);
            }
        }
    }

    private void loadOptions() {
        this.showHoverInfo = this.config.showHoverInfo();
        this.showOverheadInfo = this.config.showOverheadInfo();
        this.showMenuInfo = this.config.showMenuInfo();
        this.triggerWithShift = this.config.triggerWithShift();
        this.showNpcId = this.config.showNpcId();
        this.showNpcAnimationId = this.config.showNpcAnimationId();
        this.showNpcPoseAnimationId = this.config.showNpcPoseAnimationId();
        this.showNpcGraphicId = this.config.showNpcGraphicId();
        this.showPlayerAnimationId = this.config.showPlayerAnimationId();
        this.showPlayerPoseAnimationId = this.config.showPlayerPoseAnimationId();
        this.showPlayerGraphicId = this.config.showPlayerGraphicId();
        this.showGameObjectId = this.config.showGameObjectId();
        this.showGroundObjectId = this.config.showGroundObjectId();
        this.showDecorativeObjectId = this.config.showDecorativeObjectId();
        this.showWallObjectId = this.config.showWallObjectId();
        this.showGroundItemId = this.config.showGroundItemId();
        this.showNpcOverrideModelIds = this.config.showNpcOverrideModelIds();
        this.showNpcOverrideColours = this.config.showNpcOverrideColours();
        this.showNpcOverrideTextures = this.config.showNpcOverrideTextures();
        this.colourHover = this.config.colourHover();
        this.colourOverhead = this.config.colourOverhead();
        this.colourMenu = this.config.colourMenu();
    }

    public boolean exclude(NPC npc) {
        return npc == null || npc.getName() == null || npc.getName().isEmpty() || "null".equals(npc.getName());
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        this.hoverText = null;
        if (this.triggerWithShift && !this.client.isKeyPressed(81)) {
            return;
        }
        MenuEntry entry = event.getMenuEntry();
        MenuAction menuAction = entry.getType();
        NPC npc = entry.getNpc();
        Player player = entry.getPlayer();
        if (!this.exclude(npc)) {
            String text;
            if (this.showNpcId) {
                text = "(ID: " + npc.getId() + ")";
                this.hoverText = text;
                if (this.showMenuInfo) {
                    entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text), (Color)this.colourMenu));
                }
            }
            if (this.showNpcAnimationId) {
                text = "(A: " + npc.getAnimation() + ")";
                if (this.hoverText == null) {
                    this.hoverText = "";
                }
                this.hoverText = this.hoverText + (this.hoverText.length() > 0 ? " " : "") + text;
                if (this.showMenuInfo) {
                    entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text), (Color)this.colourMenu));
                }
            }
            if (this.showNpcPoseAnimationId) {
                text = "(P: " + npc.getPoseAnimation() + ")";
                if (this.hoverText == null) {
                    this.hoverText = "";
                }
                this.hoverText = this.hoverText + (this.hoverText.length() > 0 ? " " : "") + text;
                if (this.showMenuInfo) {
                    entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text), (Color)this.colourMenu));
                }
            }
            if (this.showNpcGraphicId) {
                text = "(G: " + npc.getGraphic() + ")";
                if (this.hoverText == null) {
                    this.hoverText = "";
                }
                this.hoverText = this.hoverText + (this.hoverText.length() > 0 ? " " : "") + text;
                if (this.showMenuInfo) {
                    entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text), (Color)this.colourMenu));
                }
            }
            if ((this.showNpcOverrideModelIds || this.showNpcOverrideColours || this.showNpcOverrideTextures) && npc.getModelOverrides() != null) {
                String text2;
                NpcOverrides modelOverrides = npc.getModelOverrides();
                if (this.showNpcOverrideModelIds && modelOverrides.getModelIds() != null) {
                    text2 = "(M: " + Arrays.toString(modelOverrides.getModelIds()) + ")";
                    if (this.hoverText == null) {
                        this.hoverText = "";
                    }
                    this.hoverText = this.hoverText + (this.hoverText.length() > 0 ? " " : "") + text2;
                    if (this.showMenuInfo) {
                        entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text2), (Color)this.colourMenu));
                    }
                }
                if (this.showNpcOverrideColours && modelOverrides.getColorToReplaceWith() != null) {
                    text2 = "(C: " + Arrays.toString(modelOverrides.getColorToReplaceWith()) + ")";
                    if (this.hoverText == null) {
                        this.hoverText = "";
                    }
                    this.hoverText = this.hoverText + (this.hoverText.length() > 0 ? " " : "") + text2;
                    if (this.showMenuInfo) {
                        entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text2), (Color)this.colourMenu));
                    }
                }
                if (this.showNpcOverrideTextures && modelOverrides.getTextureToReplaceWith() != null) {
                    text2 = "(T: " + Arrays.toString(modelOverrides.getTextureToReplaceWith()) + ")";
                    if (this.hoverText == null) {
                        this.hoverText = "";
                    }
                    this.hoverText = this.hoverText + (this.hoverText.length() > 0 ? " " : "") + text2;
                    if (this.showMenuInfo) {
                        entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text2), (Color)this.colourMenu));
                    }
                }
            }
        } else if (player != null) {
            String text;
            if (this.showPlayerAnimationId) {
                text = "(A: " + player.getAnimation() + ")";
                this.hoverText = text;
                if (this.showMenuInfo) {
                    entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text), (Color)this.colourMenu));
                }
            }
            if (this.showPlayerPoseAnimationId) {
                text = "(P: " + player.getPoseAnimation() + ")";
                if (this.hoverText == null) {
                    this.hoverText = "";
                }
                this.hoverText = this.hoverText + (this.hoverText.length() > 0 ? " " : "") + text;
                if (this.showMenuInfo) {
                    entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text), (Color)this.colourMenu));
                }
            }
            if (this.showPlayerGraphicId) {
                text = "(G: " + player.getGraphic() + ")";
                if (this.hoverText == null) {
                    this.hoverText = "";
                }
                this.hoverText = this.hoverText + (this.hoverText.length() > 0 ? " " : "") + text;
                if (this.showMenuInfo) {
                    entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + text), (Color)this.colourMenu));
                }
            }
        } else if (OBJECT_MENU_TYPES.contains(menuAction)) {
            if (this.showGameObjectId || this.showGroundObjectId || this.showDecorativeObjectId || this.showWallObjectId) {
                this.hoverText = "(ID: " + entry.getIdentifier() + ")";
                if (this.showMenuInfo) {
                    entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + this.hoverText), (Color)this.colourMenu));
                }
            }
        } else if (GROUND_ITEM_MENU_TYPES.contains(menuAction) && this.showGroundItemId) {
            this.hoverText = "(ID: " + entry.getIdentifier() + ")";
            if (this.showMenuInfo) {
                entry.setTarget(entry.getTarget() + ColorUtil.wrapWithColorTag((String)(" " + this.hoverText), (Color)this.colourMenu));
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        int tickCount = this.client.getTickCount() - this.loginTickCount;
        int timestamp = this.config.logRelativeTickTimestamp() ? tickCount - this.lastTickCount : tickCount;
        int playerAnimationId = player.getAnimation();
        int playerPoseAnimationId = player.getPoseAnimation();
        int playerGraphicId = player.getGraphic();
        if (playerAnimationId != this.lastPlayerAnimationId) {
            if (this.config.logPlayerAnimationId()) {
                this.panel.appendText(timestamp + PANEL_DELIMITER + playerAnimationId);
            }
            this.lastTickCount = tickCount;
            this.lastPlayerAnimationId = playerAnimationId;
        }
        if (playerPoseAnimationId != this.lastPlayerPoseAnimationId) {
            if (this.config.logPlayerPoseAnimationId()) {
                this.panel.appendText(timestamp + PANEL_DELIMITER + playerPoseAnimationId);
            }
            this.lastTickCount = tickCount;
            this.lastPlayerPoseAnimationId = playerPoseAnimationId;
        }
        if (playerGraphicId != this.lastPlayerGraphicId) {
            if (this.config.logPlayerGraphicId()) {
                this.panel.appendText(timestamp + PANEL_DELIMITER + playerGraphicId);
            }
            this.lastTickCount = tickCount;
            this.lastPlayerGraphicId = playerGraphicId;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (ChatMessageType.WELCOME.equals((Object)event.getType())) {
            this.loginTickCount = this.client.getTickCount();
        }
    }
}

