/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.waveinfo;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.Round;
import begosrs.barbarianassault.Wave;
import begosrs.barbarianassault.timer.TimeUnits;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WaveInfoOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(WaveInfoOverlay.class);
    private static final int WAVE_CHECKMARK_ORIGINAL_X = 6;
    private static final int WAVE_ICON_ORIGINAL_X = 3;
    private final Client client;
    private final BaMinigamePlugin plugin;
    private final BaMinigameConfig config;

    @Inject
    private WaveInfoOverlay(Client client, BaMinigamePlugin plugin, BaMinigameConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        Widget waveTimer;
        Widget roleCounter;
        Widget waveInfo;
        Widget waveSprite;
        Widget waveText;
        Wave wave = this.plugin.getWave();
        Round round = this.plugin.getRound();
        if (wave == null || round == null) {
            return null;
        }
        Role role = wave.getRole();
        if (role == null) {
            return null;
        }
        if (this.config.showWaveTimer() && (waveText = this.client.getWidget(role.getWaveText().getGroupId(), role.getWaveText().getChildId())) != null) {
            TimeUnits units = this.config.timeUnits();
            String waveTime = String.format(units.getFormatString(), Float.valueOf(wave.getTimeElapsed(true, units)));
            waveText.setText("Wave " + wave.getNumber() + " / " + waveTime);
        }
        if (this.config.showWaveCompleted() && (waveSprite = this.client.getWidget(role.getWaveSprite().getGroupId(), role.getWaveSprite().getChildId())) != null) {
            waveSprite.setSpriteId(wave.isComplete() ? 699 : 697);
            waveSprite.setOriginalWidth(13);
            waveSprite.setOriginalX(6);
        }
        if ((waveInfo = this.client.getWidget(role.getWaveInfo().getGroupId(), role.getWaveInfo().getChildId())) != null && (roleCounter = waveInfo.getChild(0)) != null) {
            Object counter = null;
            if (this.config.showEggCountOverlay() && role == Role.COLLECTOR) {
                int currentWave = wave.getNumber();
                int waveCollectedEggs = currentWave == 10 ? 0 : wave.getCollectedEggsCount();
                int roundCollectedEggs = round.getCollectedEggsCount(waveCollectedEggs);
                counter = wave.getNumber() != 10 ? waveCollectedEggs + " / " + roundCollectedEggs : String.valueOf(roundCollectedEggs);
            } else if (this.config.showHpCountOverlay() && role == Role.HEALER) {
                int currentWave = wave.getNumber();
                int waveHpHealed = currentWave == 10 ? 0 : wave.getHpHealed();
                int roundHpHealed = round.getHpHealed(waveHpHealed);
                counter = wave.getNumber() != 10 ? waveHpHealed + " / " + roundHpHealed : String.valueOf(roundHpHealed);
            }
            if (counter != null) {
                roleCounter.setText(counter);
            }
        }
        if (this.config.showCallChangeTimer() && waveInfo != null && (waveTimer = waveInfo.getChild(2)) != null) {
            waveTimer.setText(String.format("00:%02d", wave.getTimeUntilCallChange()));
        }
        return null;
    }
}

