/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.timer;

import begosrs.barbarianassault.timer.TimeUnits;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer {
    private static final Logger log = LoggerFactory.getLogger(Timer.class);
    private final Instant roundStartTime;
    private int roundTicks;
    private Instant roundEndTime;
    private int roundEndTicks;
    private Instant waveStartTime;
    private int waveTickStart;

    public Timer() {
        this.waveStartTime = this.roundStartTime = Instant.now();
    }

    private static LocalTime timeFromMillis(int millis) {
        return LocalTime.ofSecondOfDay(millis / 1000).plus(millis % 1000, ChronoUnit.MILLIS);
    }

    private static LocalTime timeFromDuration(Duration duration) {
        return LocalTime.ofSecondOfDay(duration.getSeconds()).plusNanos(duration.getNano());
    }

    private static String formatTime(LocalTime time, TimeUnits units) {
        if (time.getHour() > 0) {
            return time.format(DateTimeFormatter.ofPattern("HH:mm"));
        }
        String minsFormat = time.getMinute() > 9 ? "mm" : "m";
        String fractional = units.equals((Object)TimeUnits.SECONDS) ? "" : "." + time.get(ChronoField.MILLI_OF_SECOND) / 100;
        return time.format(DateTimeFormatter.ofPattern(minsFormat + ":ss")) + fractional;
    }

    public Duration getRoundTime() {
        if (this.roundEndTime == null) {
            this.roundEndTime = Instant.now();
        }
        return Duration.between(this.roundStartTime, this.roundEndTime);
    }

    public Duration getWaveTime() {
        return Duration.between(this.waveStartTime, Instant.now());
    }

    public int getCurrentWaveTick(boolean delayed) {
        return delayed ? this.roundTicks - this.waveTickStart - 1 : this.roundTicks - this.waveTickStart;
    }

    public String getRoundTimeFormatted(TimeUnits units) {
        LocalTime time = units.equals((Object)TimeUnits.TICKS) ? Timer.timeFromMillis(this.getRoundEndTicks() * 600) : Timer.timeFromDuration(this.getRoundTime());
        return Timer.formatTime(time, units);
    }

    public String getWaveTimeFormatted(TimeUnits units) {
        LocalTime time = units.equals((Object)TimeUnits.TICKS) ? Timer.timeFromMillis(this.getCurrentWaveTick(false) * 600) : Timer.timeFromDuration(this.getWaveTime());
        return Timer.formatTime(time, units);
    }

    public void setWaveStartTime() {
        this.waveStartTime = Instant.now();
        this.waveTickStart = this.roundTicks;
    }

    public void setRoundEnded() {
        this.roundEndTime = Instant.now();
        this.roundEndTicks = this.roundTicks;
    }

    public void onGameTick() {
        ++this.roundTicks;
    }

    public Instant getRoundStartTime() {
        return this.roundStartTime;
    }

    public int getRoundTicks() {
        return this.roundTicks;
    }

    public Instant getRoundEndTime() {
        return this.roundEndTime;
    }

    public int getRoundEndTicks() {
        return this.roundEndTicks;
    }

    public Instant getWaveStartTime() {
        return this.waveStartTime;
    }

    public int getWaveTickStart() {
        return this.waveTickStart;
    }
}

