/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.ticktimer;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.ticktimer.RunnerTickTimer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TitleComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RunnerTickTimerOverlay
extends OverlayPanel {
    private static final Logger log = LoggerFactory.getLogger(RunnerTickTimerOverlay.class);
    private static final int DEFAULT_WIDTH = 20;
    private final BaMinigamePlugin plugin;
    private final BaMinigameConfig config;

    @Inject
    private RunnerTickTimerOverlay(BaMinigamePlugin plugin, BaMinigameConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        RunnerTickTimer runnerTickTimer;
        Role role = this.plugin.getRole();
        if ((role == Role.ATTACKER && this.config.showRunnerTickTimerAttacker() || role == Role.DEFENDER && this.config.showRunnerTickTimerDefender() || role == Role.COLLECTOR && this.config.showRunnerTickTimerCollector() || role == Role.HEALER && this.config.showRunnerTickTimerHealer()) && (runnerTickTimer = this.plugin.getRunnerTickTimer()) != null && runnerTickTimer.isDisplaying()) {
            int tickCount = runnerTickTimer.getCount();
            TitleComponent titleComponent = TitleComponent.builder().text(String.valueOf(tickCount)).color(runnerTickTimer.getColor()).build();
            this.panelComponent.getChildren().add(titleComponent);
            this.panelComponent.setPreferredSize(new Dimension(20, 0));
            return super.render(graphics);
        }
        return null;
    }
}

