/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.teamhealthbar;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.api.widgets.BaWidgetInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class TeamHealthBarOverlay
extends Overlay {
    private final Client client;
    private final BaMinigamePlugin plugin;
    private final BaMinigameConfig config;

    @Inject
    private TeamHealthBarOverlay(Client client, BaMinigamePlugin plugin, BaMinigameConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        Role role = this.plugin.getRole();
        if (this.config.showTeammateHealthBars() && this.plugin.isDisplayingHealerTeammatesHealth() && role == Role.HEALER) {
            for (HealerTeam teammate : HealerTeam.values()) {
                Widget widget = this.client.getWidget(teammate.getTeammate().getGroupId(), teammate.getTeammate().getChildId());
                if (widget == null) continue;
                String[] teammateHealth = widget.getText().split(" / ");
                int curHealth = Integer.parseInt(teammateHealth[0]);
                int maxHealth = Integer.parseInt(teammateHealth[1]);
                int width = teammate.getWidth();
                double hpRatio = (double)curHealth / (double)maxHealth;
                int filledWidth = this.getBarWidth(hpRatio, width);
                Color barColor = this.getBarColor(hpRatio);
                int offsetX = teammate.getOffsetX();
                int offsetY = teammate.getOffsetY();
                int x = widget.getCanvasLocation().getX() - offsetX;
                int y = widget.getCanvasLocation().getY() - offsetY;
                graphics.setColor(barColor);
                graphics.fillRect(x, y, filledWidth, 20);
            }
        }
        return null;
    }

    private int getBarWidth(double ratio, int size) {
        if (ratio >= 1.0) {
            return size;
        }
        return (int)Math.round(ratio * (double)size);
    }

    private Color getBarColor(double ratio) {
        int transparency = this.config.teammateHealthBarTransparency();
        if (ratio <= 0.33) {
            return new Color(225, 35, 0, 255 - transparency);
        }
        if (ratio <= 0.66) {
            return new Color(146, 146, 0, 255 - transparency);
        }
        return new Color(10, 146, 5, 255 - transparency);
    }

    private static enum HealerTeam {
        TEAMMATE1(BaWidgetInfo.BA_HEAL_TEAMMATE1, 28, 2, 115),
        TEAMMATE2(BaWidgetInfo.BA_HEAL_TEAMMATE2, 26, 2, 115),
        TEAMMATE3(BaWidgetInfo.BA_HEAL_TEAMMATE3, 26, 2, 115),
        TEAMMATE4(BaWidgetInfo.BA_HEAL_TEAMMATE4, 25, 2, 115);

        private final BaWidgetInfo teammate;
        private final int offsetX;
        private final int offsetY;
        private final int width;

        public BaWidgetInfo getTeammate() {
            return this.teammate;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public int getWidth() {
            return this.width;
        }

        private HealerTeam(BaWidgetInfo teammate, int offsetX, int offsetY, int width) {
            this.teammate = teammate;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.width = width;
        }
    }
}

