/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.points;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.points.DisplayPointsMode;
import begosrs.barbarianassault.points.RolePointsTrackingMode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.util.ColorUtil;

public class RolePointsOverlay
extends OverlayPanel {
    private final BaMinigameConfig config;
    private final BaMinigamePlugin plugin;

    @Inject
    private RolePointsOverlay(BaMinigameConfig config, BaMinigamePlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.MED);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Ba role points overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.displayPointsMode() != DisplayPointsMode.TEXT_BOX || !this.plugin.shouldDisplayRolePoints()) {
            return null;
        }
        RolePointsTrackingMode rolePointsTrackingMode = this.config.rolePointsTrackingMode();
        for (Map.Entry<Role, Integer> rolePoints : this.plugin.getRolePoints().entrySet()) {
            Role role = rolePoints.getKey();
            if (rolePointsTrackingMode == RolePointsTrackingMode.ATTACKER && role != Role.ATTACKER || rolePointsTrackingMode == RolePointsTrackingMode.DEFENDER && role != Role.DEFENDER || rolePointsTrackingMode == RolePointsTrackingMode.HEALER && role != Role.HEALER || rolePointsTrackingMode == RolePointsTrackingMode.COLLECTOR && role != Role.COLLECTOR) continue;
            Integer points = rolePoints.getValue();
            this.addPanelComponentPoints(role, points);
        }
        return super.render(graphics);
    }

    private void addPanelComponentPoints(Role role, Integer points) {
        String pts = points == null ? "-" : Integer.toString(points);
        Color strColor = role.getColor();
        String str = ColorUtil.prependColorTag((String)pts, (Color)strColor);
        this.panelComponent.getChildren().add(LineComponent.builder().left(role.getName()).right(str).rightColor(strColor).build());
    }
}

